/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.configuration.ConfigurationLocale;
import io.github.guillex7.explodeany.configuration.loadable.LoadableSectionConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.util.MessageFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class ConfigurationManager {
    private static final String USE_BLOCK_DATABASE_ITEM = "UseBlockDatabase";
    private static final String CHECK_BLOCK_DATABASE_AT_STARTUP_ITEM = "CheckBlockDatabaseAtStartup";
    private static final String BLOCK_DURABILITY_ITEM = "BlockDurability";
    private static final String GROUPS_SECTION = "Groups";
    private static final String LOCALE_SECTION = "Locale";
    private static ConfigurationManager instance;
    private Map<String, LoadableSectionConfiguration<?>> registeredEntityConfigurations = new HashMap();
    private Set<Material> handledMaterials = new HashSet<Material>();

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public ExplodeAny getPlugin() {
        return ExplodeAny.getInstance();
    }

    public static double ensureRange(double value, double max, double min) {
        return Math.min(Math.max(value, min), max);
    }

    public static double ensureMax(double value, double max) {
        return Math.min(value, max);
    }

    public static double ensureMin(double value, double min) {
        return Math.max(value, min);
    }

    public static int ensureRange(int value, int max, int min) {
        return Math.min(Math.max(value, min), max);
    }

    public static int ensureMax(int value, int max) {
        return Math.min(value, max);
    }

    public static int ensureMin(int value, int min) {
        return Math.max(value, min);
    }

    public Map<String, LoadableSectionConfiguration<?>> getRegisteredEntityConfigurations() {
        return this.registeredEntityConfigurations;
    }

    public LoadableSectionConfiguration<?> getRegisteredEntityConfiguration(String sectionPath) {
        return this.getRegisteredEntityConfigurations().get(sectionPath);
    }

    public Set<Material> getHandledMaterials() {
        return this.handledMaterials;
    }

    public boolean handlesBlock(Block block) {
        return this.getHandledMaterials().contains(block.getType());
    }

    public boolean doUseBlockDatabase() {
        return this.getPlugin().getConfig().getBoolean(USE_BLOCK_DATABASE_ITEM);
    }

    public boolean doCheckBlockDatabaseAtStartup() {
        return this.getPlugin().getConfig().getBoolean(CHECK_BLOCK_DATABASE_AT_STARTUP_ITEM);
    }

    public Double getBlockDurability() {
        return ConfigurationManager.ensureMin(this.getPlugin().getConfig().getDouble(BLOCK_DURABILITY_ITEM), 1.0);
    }

    public Map<String, List<String>> getGroups() {
        ConfigurationSection groupsSection = this.getPlugin().getConfig().getConfigurationSection(GROUPS_SECTION);
        HashMap<String, List<String>> groups = new HashMap<String, List<String>>();
        for (String groupName : groupsSection.getKeys(false)) {
            groups.put(groupName, groupsSection.getStringList(groupName));
        }
        return groups;
    }

    public void loadConfiguration() {
        this.getPlugin().saveDefaultConfig();
        this.getPlugin().reloadConfig();
        this.getPlugin().getConfig().options().copyDefaults(true);
        this.getPlugin().saveConfig();
        this.getPlugin().saveResource("exampleConfig.yml", true);
        this.colorizeLocale();
    }

    private void colorizeLocale() {
        ConfigurationSection localeSection = this.getPlugin().getConfig().getConfigurationSection(LOCALE_SECTION);
        if (localeSection != null) {
            for (String path : localeSection.getValues(false).keySet()) {
                if (!localeSection.isString(path)) continue;
                localeSection.set(path, (Object)MessageFormatter.colorize(localeSection.getString(path)));
            }
        }
    }

    public String getLocale(ConfigurationLocale locale) {
        return this.getPlugin().getConfig().getString(String.format("%s.%s", LOCALE_SECTION, locale.getPath()));
    }

    public void registerEntityConfiguration(LoadableSectionConfiguration<?> entityConfiguration) {
        this.getRegisteredEntityConfigurations().put(entityConfiguration.getSectionPath(), entityConfiguration);
    }

    public void loadAllEntityConfigurations() {
        FileConfiguration config = this.getPlugin().getConfig();
        for (LoadableSectionConfiguration<?> entityConfiguration : this.getRegisteredEntityConfigurations().values()) {
            if (!entityConfiguration.shouldBeLoaded()) continue;
            entityConfiguration.clearEntityMaterialConfigurations();
            entityConfiguration.fetchEntityMaterialConfigurations(config);
            for (Map<Material, EntityMaterialConfiguration> map : entityConfiguration.getEntityMaterialConfigurations().values()) {
                this.getHandledMaterials().addAll(map.keySet());
            }
        }
    }

    public void unloadAllEntityConfigurations() {
        this.getRegisteredEntityConfigurations().clear();
        this.getHandledMaterials().clear();
    }
}

