/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import io.github.guillex7.explodeany.block.BlockLocation;
import io.github.guillex7.gson.TypeAdapter;
import io.github.guillex7.gson.stream.JsonReader;
import io.github.guillex7.gson.stream.JsonToken;
import io.github.guillex7.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;

public class BlockLocationAdapter
extends TypeAdapter<BlockLocation> {
    @Override
    public void write(JsonWriter out, BlockLocation value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(String.format("%s:%d:%d:%d", value.getWorldUUID().toString(), value.getX(), value.getY(), value.getZ()));
    }

    @Override
    public BlockLocation read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String[] parts = in.nextString().split(":");
        return BlockLocation.of(UUID.fromString(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
    }
}

