/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.command.CommandManager;
import io.github.guillex7.explodeany.command.registrable.CommandEany;
import io.github.guillex7.explodeany.command.registrable.RegistrableCommand;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.CannonProjectileConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.VanillaEntityConfiguration;
import io.github.guillex7.explodeany.listener.ListenerManager;
import io.github.guillex7.explodeany.listener.loadable.BlockListener;
import io.github.guillex7.explodeany.listener.loadable.CannonExplosionListener;
import io.github.guillex7.explodeany.listener.loadable.EntityListener;
import io.github.guillex7.explodeany.listener.loadable.VanillaExplosionListener;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplodeAny
extends JavaPlugin {
    private final String databaseFilename = "blockDatabase.json";

    public void onEnable() {
        super.onEnable();
        this.getLogger().info(String.format("%s v%s is LOADING now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.loadConfiguration();
        this.loadDatabase();
        this.registerListeners();
        this.registerCommands();
    }

    public void onDisable() {
        super.onDisable();
        this.getLogger().info(String.format("%s v%s is UNLOADING now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.unregisterListeners();
        this.unloadDatabase();
        this.unloadConfiguration();
    }

    public void loadConfiguration() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.loadConfiguration();
        configurationManager.registerEntityConfiguration(VanillaEntityConfiguration.empty());
        configurationManager.registerEntityConfiguration(CannonProjectileConfiguration.empty());
        configurationManager.loadAllEntityConfigurations();
    }

    public void loadDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase blockDatabase = BlockDatabase.getInstance();
            blockDatabase.loadFromFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
            blockDatabase.sanitize();
            this.unloadDatabase();
        }
    }

    public void registerListeners() {
        ListenerManager listenerManager = ListenerManager.getInstance();
        listenerManager.registerListener(VanillaExplosionListener.empty());
        listenerManager.registerListener(CannonExplosionListener.empty());
        listenerManager.registerListener(BlockListener.empty());
        listenerManager.registerListener(EntityListener.empty());
        listenerManager.loadAllListeners();
    }

    public void registerCommands() {
        CommandManager commandManager = CommandManager.getInstance();
        commandManager.registerCommand(CommandEany.empty());
        for (RegistrableCommand command : commandManager.getRegisteredCommands().values()) {
            this.getCommand(command.getName()).setExecutor((CommandExecutor)commandManager);
        }
    }

    public void unloadConfiguration() {
        ConfigurationManager.getInstance().unloadAllEntityConfigurations();
    }

    public void unloadDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase.getInstance().saveToFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
        }
    }

    public void unregisterListeners() {
        ListenerManager listenerManager = ListenerManager.getInstance();
        listenerManager.unloadAllListeners();
        listenerManager.unregisterAllListeners();
    }

    public String getDatabaseFilename() {
        return "blockDatabase.json";
    }

    public static ExplodeAny getInstance() {
        return (ExplodeAny)JavaPlugin.getPlugin(ExplodeAny.class);
    }
}

