/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.util;

import java.util.Arrays;
import java.util.Random;

public class HexColor {
    protected static final char[] VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static final HexColor[] RGB = new HexColor[]{RED, GREEN, BLUE};
    protected static final HexColor[] CMY = new HexColor[]{CYAN, MAGENTA, YELLOW};
    protected static final HexColor[] DEFAULTS = new HexColor[]{RED, GREEN, BLUE, CYAN, MAGENTA, YELLOW, WHITE, BLACK};
    public static final HexColor RED = new HexColor("ff0000");
    public static final HexColor GREEN = new HexColor("00ff00");
    public static final HexColor BLUE = new HexColor("0000ff");
    public static final HexColor WHITE = new HexColor("ffffff");
    public static final HexColor BLACK = new HexColor();
    public static final HexColor CYAN = BLUE.add(GREEN);
    public static final HexColor MAGENTA = RED.add(BLUE);
    public static final HexColor YELLOW = RED.add(GREEN);
    private String hexcode;

    public HexColor() {
        this("000000");
    }

    public HexColor(int r, int g, int b) {
        this.hexcode = this.fromRGB(r, g, b);
    }

    public HexColor(String hexcode) {
        hexcode = hexcode.toLowerCase();
        if (hexcode.startsWith("#")) {
            hexcode = hexcode.substring(1, hexcode.length());
        }
        if (!hexcode.matches("[0-9a-f]{6}")) {
            hexcode = "000000";
        }
        this.hexcode = hexcode;
    }

    public HexColor(Random rand) {
        this(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256));
    }

    private String fromRGB(int r, int g, int b) {
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        int[] rgb = new int[]{r, g, b};
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int first = (int)Math.floor(rgb[i] / 16);
            int second = rgb[i] % 16;
            hex.append(VALUES[first]);
            hex.append(VALUES[second]);
        }
        return hex.toString();
    }

    public HexColor add(HexColor color) {
        int[] a = this.toRGB();
        int[] b = color.toRGB();
        int[] outcome = new int[]{0, 0, 0};
        for (int i = 0; i < 3; ++i) {
            int newVal;
            outcome[i] = newVal = Math.min(Math.max(0, a[i] + b[i]), 255);
        }
        return new HexColor(outcome[0], outcome[1], outcome[2]);
    }

    public HexColor subtract(HexColor color) {
        int[] a = this.toRGB();
        int[] b = color.toRGB();
        int[] outcome = new int[]{0, 0, 0};
        for (int i = 0; i < 3; ++i) {
            int newVal;
            outcome[i] = newVal = Math.min(Math.max(0, a[i] - b[i]), 255);
        }
        return new HexColor(outcome[0], outcome[1], outcome[2]);
    }

    public int[] toRGB() {
        String red = this.hexcode.substring(0, 2);
        String green = this.hexcode.substring(2, 4);
        String blue = this.hexcode.substring(4, 6);
        char[] reds = red.toCharArray();
        char[] greens = green.toCharArray();
        char[] blues = blue.toCharArray();
        int redVal = Arrays.binarySearch(VALUES, reds[0]) * 16 + Arrays.binarySearch(VALUES, reds[1]);
        int greenVal = Arrays.binarySearch(VALUES, greens[0]) * 16 + Arrays.binarySearch(VALUES, greens[1]);
        int blueVal = Arrays.binarySearch(VALUES, blues[0]) * 16 + Arrays.binarySearch(VALUES, blues[1]);
        return new int[]{redVal, greenVal, blueVal};
    }

    public boolean matches(HexColor color) {
        return this.hexcode.equalsIgnoreCase(color.getHexcode());
    }

    public String getHexcode() {
        return this.hexcode;
    }

    public static HexColor[] values() {
        return DEFAULTS;
    }

    public static HexColor[] rgb() {
        return RGB;
    }

    public static HexColor[] cmy() {
        return CMY;
    }
}

