/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.water;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.PlantAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class RazorLeaf
extends PlantAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Radius")
    private double radius;
    @Attribute(value="Range")
    private double range;
    private Location center;
    private int particles;
    private TempBlock source;
    private Vector direction;

    public RazorLeaf(Player player, boolean sourced) {
        super(player);
        if (RazorLeaf.hasAbility((Player)player, RazorLeaf.class)) {
            return;
        }
        if (sourced) {
            Block source = player.getTargetBlock((Set)RazorLeaf.getTransparentMaterialSet(), 7);
            if (!this.isPlantbendable(source.getType())) {
                return;
            }
            this.source = new TempBlock(source, Material.AIR);
            this.center = source.getLocation().clone().add(0.5, 0.5, 0.5);
        } else {
            this.source = null;
            this.center = player.getEyeLocation().clone().add(player.getEyeLocation().getDirection().clone().normalize().multiply(1.5));
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Water.RazorLeaf.Cooldown");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.RazorLeaf.Damage");
        this.radius = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.RazorLeaf.Radius");
        this.range = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.RazorLeaf.Range");
        this.particles = ProjectAddons.instance.getConfig().getInt("Abilities.Water.RazorLeaf.Particles");
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.player.getWorld().equals(this.center.getWorld())) {
            this.remove();
            return;
        }
        if (this.center.distance(this.player.getEyeLocation()) >= this.range) {
            this.remove();
            return;
        }
        if (this.player.isSneaking()) {
            Location holding = this.player.getEyeLocation().clone().add(this.player.getEyeLocation().getDirection().clone().normalize().multiply(1.5));
            this.direction = GeneralMethods.getDirection((Location)this.center, (Location)holding);
        } else {
            Location target = null;
            Entity e = GeneralMethods.getTargetedEntity((Player)this.player, (double)this.range);
            target = e == null || !(e instanceof LivingEntity) ? GeneralMethods.getTargetedLocation((Player)this.player, (double)this.range, (Material[])new Material[0]) : e.getLocation().clone().add(0.0, 1.0, 0.0);
            this.direction = GeneralMethods.getDirection((Location)this.center, (Location)target);
        }
        this.center = this.direction.length() > 1.0 ? this.center.add(this.direction.normalize().multiply(0.75)) : this.center.add(this.direction);
        if (!this.center.getBlock().isPassable()) {
            this.remove();
            return;
        }
        RazorLeaf.playPlantbendingSound((Location)this.center);
        for (int n = 0; n < this.particles; ++n) {
            Location start = this.center.clone();
            double c = 0.075;
            double phi = (double)n * 137.5;
            double r = c * Math.sqrt(n);
            double x = r * Math.cos(Math.toRadians(phi));
            double z = r * Math.sin(Math.toRadians(phi));
            Location current = start.clone().add(x, 0.0, z);
            if (current.distance(start) > this.radius) break;
            GeneralMethods.displayColoredParticle((String)"3D9970", (Location)current);
        }
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.center, (double)(this.radius + 1.0))) {
            if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
            DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
            this.remove();
            return;
        }
    }

    public void remove() {
        super.remove();
        if (this.source != null && this.source.getBlock().getType() == Material.AIR) {
            this.source.revertBlock();
        }
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "RazorLeaf";
    }

    public Location getLocation() {
        return this.center;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Spin leaves around really fast and make them razor sharp!";
    }

    public String getInstructions() {
        return "Sneak at plants to begin, hold to aim, and release to shoot it! Sneaking again will pull it back towards you!";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Water.RazorLeaf.Enabled");
    }
}

