/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.water;

import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.MultiAbility;
import com.projectkorra.projectkorra.ability.PlantAbility;
import com.projectkorra.projectkorra.ability.util.MultiAbilityManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.earthbending.EarthArmor;
import com.projectkorra.projectkorra.util.ActionBar;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.MovementHandler;
import com.projectkorra.projectkorra.util.TempArmor;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.water.RazorLeaf;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PlantArmor
extends PlantAbility
implements AddonAbility,
MultiAbility {
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Durability")
    private int maxDurability;
    @Attribute(value="SwimBoost")
    private int swim;
    @Attribute(value="SpeedBoost")
    private int speed;
    @Attribute(value="JumpBoost")
    private int jump;
    private int durability;
    private ArmorState state;
    private ArmorAbility active;
    private BossBar bar;
    private ItemStack[] armors;
    private TempArmor armor;
    private World origin;
    private Location current;
    private Vector direction;
    @Attribute(value="RequiredPlants")
    private int requiredPlants;
    @Attribute(value="SelectRange")
    private double selectRange;
    private Set<TempBlock> sources;
    @Attribute(value="VineWhip_Range")
    private int maxRange;
    @Attribute(value="VineWhip_Damage")
    private double vdmg;
    private boolean forward;
    private int range;
    @Attribute(value="LeafShield_Radius")
    private int radius;
    private Set<TempBlock> shield;
    @Attribute(value="Tangle_Radius")
    private double tRadius;
    @Attribute(value="Tangle_Duration")
    private long tDuration;
    @Attribute(value="Tangle_Range")
    private double tRange;
    private int angle;
    @Attribute(value="Grapple_Range")
    private int gMax;
    @Attribute(value="Grapple_Speed")
    private double gSpeed;
    private Location target;
    private int gRange;
    private boolean pulling;
    @Attribute(value="Leap_Power")
    private double power;
    @Attribute(value="LeafDome_Radius")
    private int dRadius;
    @Attribute(value="Regenerate_Amount")
    private int regen;

    public PlantArmor(Player player, ClickType type) {
        super(player);
        if (!this.bPlayer.canBendIgnoreBinds((CoreAbility)this)) {
            return;
        }
        if (PlantArmor.hasAbility((Player)player, EarthArmor.class)) {
            return;
        }
        PlantArmor abil = (PlantArmor)PlantArmor.getAbility((Player)player, PlantArmor.class);
        if (abil != null) {
            abil.activate(player.getInventory().getHeldItemSlot(), type);
            return;
        }
        if (type == ClickType.SHIFT_DOWN) {
            MultiAbilityManager.bindMultiAbility((Player)player, (String)"PlantArmor");
            this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Water.PlantArmor.Duration");
            this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Water.PlantArmor.Cooldown");
            this.durability = this.maxDurability = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.Durability");
            this.swim = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.Boost.Swim") - 1;
            this.speed = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.Boost.Speed") - 1;
            this.jump = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.Boost.Jump") - 1;
            this.armor = null;
            ItemStack head = new ItemStack(Material.OAK_LEAVES, 1);
            ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE, 1);
            ItemStack leggings = new ItemStack(Material.LEATHER_LEGGINGS, 1);
            ItemStack boots = new ItemStack(Material.LEATHER_BOOTS, 1);
            LeatherArmorMeta metaChest = (LeatherArmorMeta)chestplate.getItemMeta();
            LeatherArmorMeta metaLegs = (LeatherArmorMeta)leggings.getItemMeta();
            LeatherArmorMeta metaBottom = (LeatherArmorMeta)boots.getItemMeta();
            metaChest.setColor(Color.fromRGB((int)61, (int)153, (int)112));
            metaLegs.setColor(Color.fromRGB((int)61, (int)153, (int)112));
            metaBottom.setColor(Color.fromRGB((int)61, (int)153, (int)112));
            chestplate.setItemMeta((ItemMeta)metaChest);
            leggings.setItemMeta((ItemMeta)metaLegs);
            boots.setItemMeta((ItemMeta)metaBottom);
            this.armors = new ItemStack[]{boots, leggings, chestplate, head};
            if (this.durability < 1000) {
                this.durability = 1000;
            } else if (this.durability > 10000) {
                this.durability = 10000;
            }
            this.state = ArmorState.FORMING;
            this.active = ArmorAbility.NONE;
            this.origin = player.getWorld();
            this.requiredPlants = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.RequiredPlants");
            this.selectRange = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SelectRange");
            this.sources = new HashSet<TempBlock>();
            this.forward = true;
            this.range = 0;
            this.maxRange = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Range");
            this.vdmg = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Damage");
            this.shield = new HashSet<TempBlock>();
            this.radius = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities.LeafShield.Radius");
            this.current = null;
            this.tRadius = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SubAbilities.Tangle.Radius");
            this.tRange = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SubAbilities.Tangle.Range");
            this.tDuration = ProjectAddons.instance.getConfig().getLong("Abilities.Water.PlantArmor.SubAbilities.Tangle.Duration");
            this.angle = 0;
            this.gMax = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities.Grapple.Range");
            this.gSpeed = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SubAbilities.Grapple.Speed");
            this.pulling = false;
            this.gRange = 0;
            this.dRadius = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities.LeafDome.Radius");
            this.power = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.PlantArmor.SubAbilities.Leap.Power");
            this.regen = ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities.Regenerate.RegenAmount");
            this.start();
        }
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.bPlayer.canBendIgnoreBinds((CoreAbility)this)) {
            this.remove();
            return;
        }
        if (!this.player.getWorld().equals(this.origin)) {
            this.remove();
            return;
        }
        if (this.durability <= 0) {
            this.remove();
            return;
        }
        if (this.duration > 0L && System.currentTimeMillis() >= this.getStartTime() + this.duration) {
            this.remove();
            return;
        }
        if (this.state == ArmorState.FORMING) {
            this.progressForming();
        } else if (this.state == ArmorState.FORMED) {
            this.bar.setProgress((double)this.durability / (double)this.maxDurability);
            if (this.bar.getProgress() <= 0.5 && this.bar.getProgress() > 0.15) {
                this.bar.setTitle(ChatColor.DARK_AQUA + "Durability [" + ChatColor.YELLOW + this.durability + ChatColor.DARK_AQUA + " / " + this.maxDurability + "]");
                this.bar.setColor(BarColor.YELLOW);
            } else if (this.bar.getProgress() <= 0.15) {
                this.bar.setTitle(ChatColor.DARK_AQUA + "Durability [" + ChatColor.RED + this.durability + ChatColor.DARK_AQUA + " / " + this.maxDurability + "]");
                this.bar.setColor(BarColor.RED);
            } else {
                this.bar.setTitle(ChatColor.DARK_AQUA + "Durability [" + ChatColor.GREEN + this.durability + ChatColor.DARK_AQUA + " / " + this.maxDurability + "]");
                this.bar.setColor(BarColor.GREEN);
            }
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 5, this.swim), true);
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 5, this.speed), true);
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 5, this.jump), true);
            if (this.active != ArmorAbility.NONE && this.player.getInventory().getHeldItemSlot() != this.active.getSlot()) {
                this.reset();
                return;
            }
            switch (this.active) {
                case VINEWHIP: {
                    this.progressVineWhip();
                    break;
                }
                case REGENERATE: {
                    this.progressRegenerate();
                    break;
                }
                case LEAFSHIELD: {
                    this.progressLeafShield();
                    break;
                }
                case TANGLE: {
                    this.progressTangle();
                    break;
                }
                case LEAP: {
                    this.leap();
                    break;
                }
                case GRAPPLE: {
                    this.progressGrapple();
                    break;
                }
                case LEAFDOME: {
                    this.progressLeafDome();
                    break;
                }
            }
        } else {
            this.remove();
            return;
        }
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
        MultiAbilityManager.unbindMultiAbility((Player)this.player);
        if (this.player != null && this.player.isOnline() && !this.player.isDead() && this.armor != null) {
            this.armor.revert();
        }
        if (!this.sources.isEmpty()) {
            for (TempBlock tb : this.sources) {
                if (tb.getBlock().getType() != Material.AIR) continue;
                tb.revertBlock();
            }
        }
        if (!this.shield.isEmpty()) {
            for (TempBlock tb : this.shield) {
                if (tb.getBlock().getType() != Material.AIR) continue;
                tb.revertBlock();
            }
        }
        this.sources.clear();
        this.shield.clear();
        this.bar.removeAll();
    }

    private void reset() {
        if (this.active != ArmorAbility.NONE) {
            this.bPlayer.addCooldown(this.active.getName(), ProjectAddons.instance.getConfig().getLong("Abilities.Water.PlantArmor.SubAbilities." + this.active.getName() + ".Cooldown"));
            this.active = ArmorAbility.NONE;
        }
        if (this.active == ArmorAbility.LEAFSHIELD) {
            this.durability += this.getAbilityCost("LeafShield");
        }
        this.range = 0;
        this.forward = true;
        if (!this.shield.isEmpty()) {
            for (TempBlock tb : this.shield) {
                tb.revertBlock();
            }
            this.shield.clear();
        }
        this.target = null;
        this.pulling = false;
        this.gRange = 0;
        this.current = null;
        this.direction = null;
        this.angle = 0;
    }

    public void activate(int slot, ClickType type) {
        if (this.active != ArmorAbility.NONE) {
            return;
        }
        ArmorAbility ability = ArmorAbility.getAbility(slot);
        if (type != ability.getType()) {
            return;
        }
        if (this.bPlayer.isOnCooldown(ability.getName())) {
            ActionBar.sendActionBar((String)(ChatColor.RED + "!> cooldown <!"), (Player[])new Player[]{this.player});
            return;
        }
        if (ability.getPredicate() != null && !ability.getPredicate().test(this.player)) {
            return;
        }
        if (ability.hasCost() && !this.damage(this.getAbilityCost(ability.getName()))) {
            return;
        }
        if (ability == ArmorAbility.RAZORLEAF) {
            new RazorLeaf(this.player, false);
        } else if (ability == ArmorAbility.DISPERSE) {
            this.state = ArmorState.DISPERSING;
        } else {
            this.active = ability;
            if (ability == ArmorAbility.GRAPPLE) {
                this.current = GeneralMethods.getRightSide((Location)this.player.getLocation(), (double)0.45).add(0.0, 1.0, 0.0);
                this.target = this.player.getTargetBlock((Set)PlantArmor.getTransparentMaterialSet(), this.gMax).getLocation().clone().add(0.5, 0.5, 0.5);
            } else {
                this.current = this.player.getEyeLocation();
                this.direction = this.current.getDirection().clone().normalize();
            }
        }
    }

    public boolean damage(int amount) {
        int diff = this.durability - amount;
        if (diff < 0) {
            return false;
        }
        this.durability = diff;
        return true;
    }

    private void progressForming() {
        Block b;
        if (this.sources.size() == this.requiredPlants) {
            this.state = ArmorState.FORMED;
            this.armor = new TempArmor((LivingEntity)this.player, 72000000L, (CoreAbility)this, this.armors);
            this.bar = Bukkit.createBossBar((String)(ChatColor.DARK_AQUA + "Durability [" + ChatColor.GREEN + this.durability + ChatColor.DARK_AQUA + " / " + this.maxDurability + "]"), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.bar.setProgress((double)this.durability / (double)this.maxDurability);
            this.bar.addPlayer(this.player);
            return;
        }
        if (!this.sources.isEmpty()) {
            Location display = this.player.getLocation().clone();
            for (int y = 0; y < this.sources.size(); ++y) {
                for (int angle = 0; angle < 360; angle += 15) {
                    double x = 0.5 * Math.cos(Math.toRadians(angle));
                    double z = 0.5 * Math.sin(Math.toRadians(angle));
                    double dy = (double)y / (double)this.requiredPlants * this.player.getHeight();
                    display.add(x, dy, z);
                    GeneralMethods.displayColoredParticle((String)"3D9970", (Location)display);
                    display.subtract(x, dy, z);
                }
            }
        }
        if ((b = this.getRandomPlantSource()) == null) {
            return;
        }
        this.sources.add(new TempBlock(b, Material.AIR));
    }

    private void progressVineWhip() {
        if (this.forward) {
            ++this.range;
            if (this.range >= this.maxRange) {
                this.forward = false;
                return;
            }
        } else {
            --this.range;
            if (this.range <= 0) {
                this.reset();
                return;
            }
        }
        Location last = GeneralMethods.getRightSide((Location)this.player.getLocation().clone().add(0.0, 1.0, 0.0), (double)0.45);
        last.getDirection().normalize().multiply(1.2);
        for (int i = 0; i < this.range; ++i) {
            last.add(last.getDirection());
            if (last.getBlock().getType().isSolid()) {
                this.forward = false;
                return;
            }
            GeneralMethods.displayColoredParticle((String)"3D9970", (Location)last, (int)3, (double)0.1, (double)0.1, (double)0.1);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)last, (double)1.0)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (double)this.vdmg, (Ability)this);
                this.forward = false;
                return;
            }
        }
    }

    private void progressLeafShield() {
        if (!this.player.isSneaking()) {
            this.reset();
            return;
        }
        if (!this.shield.isEmpty()) {
            for (TempBlock tb : this.shield) {
                tb.revertBlock();
            }
            this.shield.clear();
        }
        Vector direction = this.player.getEyeLocation().getDirection().clone();
        Location center = this.player.getEyeLocation().clone().add(direction.normalize().multiply(this.radius + 1));
        this.shield.add(new TempBlock(center.getBlock(), Material.OAK_LEAVES));
        for (int i = 1; i <= this.radius; ++i) {
            for (double angle = 0.0; angle < 360.0; angle += (double)(360 / (i * 9))) {
                Vector ortho = GeneralMethods.getOrthogonalVector((Vector)direction, (double)angle, (double)i);
                center.add(ortho);
                Block b = center.getBlock();
                if ((PlantArmor.isAir((Material)b.getType()) || b.isPassable()) && !TempBlock.isTempBlock((Block)b)) {
                    this.shield.add(new TempBlock(b, Material.OAK_LEAVES));
                }
                center.subtract(ortho);
            }
        }
    }

    private void progressTangle() {
        if (this.player.getEyeLocation().distance(this.current) > this.tRange) {
            this.reset();
            return;
        }
        this.current.add(this.direction);
        if (!this.current.getBlock().isPassable()) {
            this.reset();
            return;
        }
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.current, (double)(this.tRadius + 0.5))) {
            if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
            new MovementHandler((LivingEntity)e, (CoreAbility)this).stopWithDuration(this.tDuration / 1000L * 20L, ChatColor.DARK_AQUA + "* Tangled *");
            new TempBlock(e.getLocation().getBlock(), Material.OAK_LEAVES).setRevertTime(this.tDuration);
            new TempBlock(e.getLocation().clone().add(0.0, e.getHeight(), 0.0).getBlock(), Material.OAK_LEAVES).setRevertTime(this.tDuration);
            this.reset();
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Vector ov = GeneralMethods.getOrthogonalVector((Vector)this.direction, (double)(this.angle + 120 * i), (double)this.tRadius);
            Location pl = this.current.clone().add(ov.clone());
            GeneralMethods.displayColoredParticle((String)"3D9970", (Location)pl);
        }
        this.angle += 30;
        if (this.angle == 360) {
            this.angle = 0;
        }
    }

    private void leap() {
        Location ground = this.player.getLocation().clone();
        for (double i = 0.0; i < 1.0; i += 0.25) {
            for (int angle = 0; angle < 360; angle += 15) {
                double x = (1.0 - i) * Math.cos(Math.toRadians(angle));
                double z = (1.0 - i) * Math.sin(Math.toRadians(angle));
                ground.add(x, i, z);
                GeneralMethods.displayColoredParticle((String)"3D9970", (Location)ground);
                ground.subtract(x, i, z);
            }
        }
        this.player.setVelocity(this.direction.add(new Vector(0.0, 0.8, 0.0)).multiply(this.power));
        this.reset();
    }

    private void progressGrapple() {
        this.current = GeneralMethods.getRightSide((Location)this.player.getLocation(), (double)0.45).add(0.0, 1.0, 0.0);
        if (this.current.distance(this.target) < 2.0) {
            this.reset();
            return;
        }
        if (!this.pulling) {
            ++this.gRange;
            if (this.gRange >= this.gMax) {
                this.reset();
                return;
            }
        } else {
            this.gRange = (int)Math.floor(this.current.distance(this.target));
        }
        Vector direction = GeneralMethods.getDirection((Location)this.current, (Location)this.target).normalize();
        for (int i = 0; i < this.gRange; ++i) {
            this.current.add(direction);
            GeneralMethods.displayColoredParticle((String)"3D9970", (Location)this.current);
            if (this.current.getBlock().isPassable() || this.pulling) continue;
            if (this.current.distance(this.target) < 1.0) {
                this.pulling = true;
                continue;
            }
            this.reset();
            return;
        }
        if (this.pulling) {
            this.player.setVelocity(direction.multiply(this.gSpeed));
        }
    }

    private void progressLeafDome() {
        if (!this.player.isSneaking()) {
            this.reset();
            return;
        }
        if (!this.shield.isEmpty()) {
            for (TempBlock tb : this.shield) {
                tb.revertBlock();
            }
            this.shield.clear();
        }
        for (Location loc : GeneralMethods.getCircle((Location)this.player.getLocation(), (int)this.dRadius, (int)0, (boolean)true, (boolean)true, (int)0)) {
            if (!loc.getBlock().isPassable() || TempBlock.isTempBlock((Block)loc.getBlock())) continue;
            this.shield.add(new TempBlock(loc.getBlock(), Material.OAK_LEAVES));
        }
        for (Location loc : GeneralMethods.getCircle((Location)this.player.getLocation(), (int)(this.dRadius - 1), (int)0, (boolean)false, (boolean)true, (int)0)) {
            if (loc.getBlock().getType() != Material.WATER || TempBlock.isTempBlock((Block)loc.getBlock())) continue;
            this.shield.add(new TempBlock(loc.getBlock(), Material.AIR));
        }
    }

    private void progressRegenerate() {
        if (!this.player.isSneaking()) {
            this.reset();
            return;
        }
        if (this.durability >= this.maxDurability) {
            this.durability = this.maxDurability;
            this.reset();
            return;
        }
        if (this.bPlayer.isOnCooldown("regen interval")) {
            return;
        }
        Block b = this.getRandomPlantSource();
        if (b == null) {
            return;
        }
        this.sources.add(new TempBlock(b, Material.AIR));
        this.durability += this.regen;
        if (this.durability >= this.maxDurability) {
            this.durability = this.maxDurability;
            this.reset();
            return;
        }
        this.bPlayer.addCooldown("regen interval", 1000L);
    }

    private int getAbilityCost(String ability) {
        return ProjectAddons.instance.getConfig().getInt("Abilities.Water.PlantArmor.SubAbilities." + ability + ".Cost");
    }

    private Block getRandomPlantSource() {
        List blocks = GeneralMethods.getBlocksAroundPoint((Location)this.player.getLocation(), (double)this.selectRange);
        Iterator iter = blocks.iterator();
        while (iter.hasNext()) {
            Block b = (Block)iter.next();
            if (this.isPlantbendable(b)) continue;
            iter.remove();
        }
        if (blocks.isEmpty()) {
            return null;
        }
        return (Block)blocks.get(new Random().nextInt(blocks.size()));
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "PlantArmor";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public ArrayList<MultiAbilityManager.MultiAbilityInfoSub> getMultiAbilities() {
        ArrayList<MultiAbilityManager.MultiAbilityInfoSub> info = new ArrayList<MultiAbilityManager.MultiAbilityInfoSub>();
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.VINEWHIP.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.RAZORLEAF.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.LEAFSHIELD.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.TANGLE.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.LEAP.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.GRAPPLE.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.LEAFDOME.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.REGENERATE.getName(), (Element)Element.PLANT));
        info.add(new MultiAbilityManager.MultiAbilityInfoSub(ArmorAbility.DISPERSE.getName(), (Element)Element.PLANT));
        return info;
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Water.PlantArmor.Enabled");
    }

    public String getDescription() {
        return "Wrap your body in vines and leaves to create a protective armor which nullifies falling and drowning damage, while also giving speed, jump, and swim boosts! The armor then acts as a source for many subabilities!" + ChatColor.WHITE + "\n[VineWhip] : " + ChatColor.DARK_AQUA + "Throw a whip of vines to damage entities!" + ChatColor.WHITE + "\n[RazorLeaf] : " + ChatColor.DARK_AQUA + "Control a spinning disc of leaves to damage entities!" + ChatColor.WHITE + "\n[LeafShield] : " + ChatColor.DARK_AQUA + "Hold a circular shield of leaves to block attacks!" + ChatColor.WHITE + "\n[Tangle] : " + ChatColor.DARK_AQUA + "Shoot a bundle of vines to constrict enemies!" + ChatColor.WHITE + "\n[Leap] : " + ChatColor.DARK_AQUA + "Launch yourself really high into the air!" + ChatColor.WHITE + "\n[Grapple] : " + ChatColor.DARK_AQUA + "Grapple to a point with your vines!" + ChatColor.WHITE + "\n[LeafDome] : " + ChatColor.DARK_AQUA + "Surround your body in a dome of leaves!" + ChatColor.WHITE + "\n[Regenerate] : " + ChatColor.DARK_AQUA + "Gather more plants to repair armor!" + ChatColor.WHITE + "\n[Disperse] : " + ChatColor.DARK_AQUA + "Deactivate your plantarmor!";
    }

    public String getInstructions() {
        return "Press sneak to activate multiability\n[VineWhip, Tangle, Leap, Grapple, Disperse]: Left Click\n[RazorLeaf, LeafShield, LeafDome, Regenerate]: Hold Sneak";
    }

    public static enum ArmorAbility {
        NONE("null", -1, false, ClickType.LEFT_CLICK, null),
        VINEWHIP("VineWhip", 0, true, ClickType.LEFT_CLICK, null),
        RAZORLEAF("RazorLeaf", 1, true, ClickType.SHIFT_DOWN, player -> !CoreAbility.hasAbility((Player)player, RazorLeaf.class)),
        LEAFSHIELD("LeafShield", 2, true, ClickType.SHIFT_DOWN, null),
        TANGLE("Tangle", 3, true, ClickType.LEFT_CLICK, null),
        LEAP("Leap", 4, true, ClickType.LEFT_CLICK, player -> player.isOnGround()),
        GRAPPLE("Grapple", 5, true, ClickType.LEFT_CLICK, null),
        LEAFDOME("LeafDome", 6, true, ClickType.SHIFT_DOWN, null),
        REGENERATE("Regenerate", 7, false, ClickType.SHIFT_DOWN, null),
        DISPERSE("Disperse", 8, false, ClickType.LEFT_CLICK, null);

        private String name;
        private int slot;
        private boolean cost;
        private ClickType type;
        private Predicate<Player> pred;

        private ArmorAbility(String name, int slot, boolean cost, ClickType type, Predicate<Player> pred) {
            this.name = name;
            this.slot = slot;
            this.cost = cost;
            this.type = type;
            this.pred = pred;
        }

        public String getName() {
            return this.name;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getDisplaySlot() {
            return this.slot + 1;
        }

        public boolean hasCost() {
            return this.cost;
        }

        public ClickType getType() {
            return this.type;
        }

        public Predicate<Player> getPredicate() {
            return this.pred;
        }

        public static ArmorAbility getAbility(int slot) {
            for (ArmorAbility ability : ArmorAbility.values()) {
                if (ability.getSlot() != slot) continue;
                return ability;
            }
            return NONE;
        }
    }

    public static enum ArmorState {
        FORMING,
        FORMED,
        DISPERSING;

    }
}

