/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.water;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.IceAbility;
import com.projectkorra.projectkorra.ability.WaterAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ActionBar;
import com.projectkorra.projectkorra.util.BlockSource;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MistShards
extends IceAbility
implements AddonAbility,
ComboAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Range")
    private double range;
    @Attribute(value="IcicleCount")
    private int icicleCount;
    private Set<Icicle> icicles;
    private Location cloud;
    private boolean forming;
    private boolean formed;

    public MistShards(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        if (MistShards.hasAbility((Player)player, MistShards.class)) {
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Water.MistShards.Cooldown");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Combos.Water.MistShards.Damage");
        this.range = ProjectAddons.instance.getConfig().getDouble("Combos.Water.MistShards.Range");
        this.icicleCount = ProjectAddons.instance.getConfig().getInt("Combos.Water.MistShards.IcicleCount");
        this.icicles = new HashSet<Icicle>();
        this.forming = true;
        this.formed = false;
        Block source = BlockSource.getWaterSourceBlock((Player)player, (double)5.0, (ClickType)ClickType.SHIFT_DOWN);
        if (source != null) {
            this.cloud = source.getLocation().add(0.5, 0.5, 0.5);
            this.start();
        }
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.forming) {
            Location target = this.player.getEyeLocation().add(0.0, 1.0, 0.0);
            this.cloud.add(GeneralMethods.getDirection((Location)this.cloud, (Location)target).normalize().multiply(0.25));
            ParticleEffect.CLOUD.display(this.cloud, 2, 0.04, 0.04, 0.04);
            if (this.cloud.distance(target) < 0.15) {
                this.formed = true;
                this.forming = false;
                ActionBar.sendActionBar((String)(ChatColor.DARK_AQUA + "" + this.icicleCount + " icicles remaining"), (Player[])new Player[]{this.player});
            }
        }
        if (!this.player.isSneaking() && this.formed) {
            this.bPlayer.addCooldown((Ability)this);
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (this.formed) {
            this.cloud = this.player.getEyeLocation().add(0.0, 1.0, 0.0);
            ParticleEffect.CLOUD.display(this.cloud, 2 * this.icicleCount, 0.3, 0.2, 0.3);
            for (int i = 0; i < 3; ++i) {
                Iterator<Icicle> iter = this.icicles.iterator();
                while (iter.hasNext()) {
                    if (iter.next().advance()) continue;
                    iter.remove();
                }
            }
            if (this.icicleCount < 1 && this.icicles.isEmpty()) {
                this.bPlayer.addCooldown((Ability)this);
                this.remove();
                return;
            }
        }
    }

    public void clickFunction() {
        if (this.icicleCount < 1 || !this.formed) {
            return;
        }
        Location start = this.cloud.clone();
        Vector direction = GeneralMethods.getDirection((Location)start, (Location)GeneralMethods.getTargetedLocation((Player)this.player, (double)this.range, (Material[])new Material[0]));
        start.setDirection(direction.normalize());
        this.icicles.add(new Icicle(start));
        --this.icicleCount;
        if (this.icicleCount > 0) {
            ActionBar.sendActionBar((String)(ChatColor.DARK_AQUA + "" + this.icicleCount + " icicles remaining"), (Player[])new Player[]{this.player});
        }
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "MistShards";
    }

    public Location getLocation() {
        return this.cloud;
    }

    public Object createNewComboInstance(Player player) {
        return new MistShards(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("WaterManipulation", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("PhaseChange", ClickType.SHIFT_UP));
        combo.add(new ComboManager.AbilityInformation("IceBlast", ClickType.SHIFT_DOWN));
        return combo;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Water.MistShards.Enabled");
    }

    public String getDescription() {
        return "Evaporate water into vapor and use the small cloud to fire icicles at enemies!";
    }

    public String getInstructions() {
        return "WaterManipulation (Hold sneak) > PhaseChange (Release sneak) > IceBlast (Hold sneak)";
    }

    class Icicle {
        Location loc;
        Location start;

        private Icicle(Location start) {
            this.loc = start.clone();
            this.start = start.clone();
        }

        public boolean advance() {
            this.loc.add(this.loc.getDirection());
            if (!this.loc.getBlock().isPassable()) {
                return false;
            }
            if (this.loc.distanceSquared(this.start) >= MistShards.this.range * MistShards.this.range) {
                return false;
            }
            GeneralMethods.displayColoredParticle((String)"62bcc0", (Location)this.loc);
            ParticleEffect.BLOCK_CRACK.display(this.loc, 1, 0.0, 0.0, 0.0, (Object)Material.BLUE_ICE.createBlockData());
            WaterAbility.playIcebendingSound((Location)this.loc);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.loc, (double)0.4)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == MistShards.this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (double)MistShards.this.damage, (Ability)MistShards.this);
                return false;
            }
            return true;
        }
    }
}

