/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.water;

import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.PlantAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.water.PlantArmor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class LeafStorm
extends PlantAbility
implements ComboAbility,
AddonAbility {
    @Attribute(value="Radius")
    private double radius;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="LeafCount")
    private int leaves;
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="LeafSpeed")
    private double angleSpeed;
    private Set<Leaf> leafTracker;

    public LeafStorm(Player player) {
        super(player);
        int cost;
        if (LeafStorm.getAbility(((Object)((Object)this)).getClass()) == null) {
            return;
        }
        if (!LeafStorm.hasAbility((Player)player, PlantArmor.class)) {
            return;
        }
        PlantArmor armor = (PlantArmor)LeafStorm.getAbility((Player)player, PlantArmor.class);
        if (!armor.damage(cost = ProjectAddons.instance.getConfig().getInt("Combos.Water.LeafStorm.PlantArmorCost"))) {
            return;
        }
        this.radius = ProjectAddons.instance.getConfig().getDouble("Combos.Water.LeafStorm.Radius");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Combos.Water.LeafStorm.Damage");
        this.leaves = ProjectAddons.instance.getConfig().getInt("Combos.Water.LeafStorm.LeafCount");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Water.LeafStorm.Cooldown");
        this.angleSpeed = ProjectAddons.instance.getConfig().getDouble("Combos.Water.LeafStorm.LeafSpeed");
        this.leafTracker = new HashSet<Leaf>();
        for (int i = 0; i < this.leaves; ++i) {
            Location loc = player.getEyeLocation().clone();
            loc.add(0.0, Math.random() * 2.0 - 1.0, 0.0);
            double angle = Math.random() * (double)new Random().nextInt(360);
            double offset = Math.random() * this.radius + 0.5;
            this.leafTracker.add(new Leaf(loc, angle, offset));
        }
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (this.player.getInventory().getHeldItemSlot() != 0) {
            this.remove();
            return;
        }
        HashSet<Leaf> removal = new HashSet<Leaf>();
        block0: for (Leaf leaf : this.leafTracker) {
            leaf.update();
            if (!leaf.getLocation().getBlock().isPassable()) {
                removal.add(leaf);
                continue;
            }
            GeneralMethods.displayColoredParticle((String)"3D9970", (Location)leaf.getLocation(), (int)2, (double)0.2, (double)0.2, (double)0.2);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)leaf.getLocation(), (double)0.5)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
                removal.add(leaf);
                continue block0;
            }
        }
        this.leafTracker.removeAll(removal);
        if (this.leafTracker.isEmpty()) {
            this.remove();
            return;
        }
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "LeafStorm";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public Object createNewComboInstance(Player player) {
        return new LeafStorm(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation(Element.WATER.getSubColor() + "RazorLeaf", ClickType.LEFT_CLICK));
        combo.add(new ComboManager.AbilityInformation(Element.WATER.getSubColor() + "RazorLeaf", ClickType.LEFT_CLICK));
        combo.add(new ComboManager.AbilityInformation(Element.WATER.getSubColor() + "VineWhip", ClickType.SHIFT_DOWN));
        return combo;
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Water.LeafStorm.Enabled");
    }

    public String getDescription() {
        return "A combo only usable in with PlantArmor, create a whirling storm of leaves around you! Leaves disappear after hitting a block or entity, or you stop sneaking.";
    }

    public String getInstructions() {
        return "RazorLeaf (Double Click) > VineWhip (Hold Sneak)";
    }

    public class Leaf {
        private Location loc;
        private double angle;
        private double radius;

        private Leaf(Location loc, double angle, double radius) {
            this.loc = loc;
            this.angle = angle;
            this.radius = radius;
        }

        public Location getLocation() {
            return this.loc;
        }

        public double getAngle() {
            return this.angle;
        }

        public Leaf update() {
            Location loc = LeafStorm.this.player.getEyeLocation().clone();
            double x = this.radius * Math.cos(Math.toRadians(this.angle));
            double z = this.radius * Math.sin(Math.toRadians(this.angle));
            loc.add(x, 0.0, z);
            loc.setY(this.loc.getY());
            this.loc = loc;
            this.angle += LeafStorm.this.angleSpeed;
            return this;
        }
    }
}

