/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.water;

import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.BloodAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.MultiAbility;
import com.projectkorra.projectkorra.ability.util.MultiAbilityManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BloodGrip
extends BloodAbility
implements AddonAbility,
MultiAbility {
    private LivingEntity target;
    private String current;
    private double health;
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Knockback")
    private double throwPower;
    @Attribute(value="MangleDamage")
    private double mangleDmg;

    public BloodGrip(Player player, boolean sneak) {
        super(player);
        if (!this.bPlayer.canBend((CoreAbility)this)) {
            return;
        }
        if (!MultiAbilityManager.hasMultiAbilityBound((Player)player, (String)this.getName()) && sneak) {
            Entity e = GeneralMethods.getTargetedEntity((Player)player, (double)8.0);
            if (e == null || !(e instanceof LivingEntity)) {
                return;
            }
            this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Water.BloodGrip.Cooldown");
            this.throwPower = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.BloodGrip.Drag.ThrowPower");
            this.mangleDmg = ProjectAddons.instance.getConfig().getDouble("Abilities.Water.BloodGrip.Mangle.Damage");
            this.health = player.getHealth();
            MultiAbilityManager.bindMultiAbility((Player)player, (String)this.getName());
        } else if (MultiAbilityManager.hasMultiAbilityBound((Player)player, (String)this.getName())) {
            BloodGrip grip = (BloodGrip)CoreAbility.getAbility((Player)player, BloodGrip.class);
            switch (player.getInventory().getHeldItemSlot()) {
                case 0: {
                    grip.throwTarget();
                }
            }
        }
    }

    public void throwTarget() {
        Vector v = GeneralMethods.getDirection((Location)this.player.getEyeLocation(), (Location)this.target.getLocation().add(0.0, 1.0, 0.0));
        this.target.setVelocity(v.normalize().multiply(this.throwPower));
        this.remove();
    }

    public void mangleTarget() {
        DamageHandler.damageEntity((Entity)this.target, (double)this.mangleDmg, (Ability)this);
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.health < this.player.getHealth()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (!this.target.getLocation().getWorld().equals(this.player.getLocation().getWorld())) {
            this.remove();
            return;
        }
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "BloodGrip";
    }

    public Location getLocation() {
        return this.target.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public ArrayList<MultiAbilityManager.MultiAbilityInfoSub> getMultiAbilities() {
        ArrayList<MultiAbilityManager.MultiAbilityInfoSub> abils = new ArrayList<MultiAbilityManager.MultiAbilityInfoSub>();
        abils.add(new MultiAbilityManager.MultiAbilityInfoSub("Drag", (Element)Element.BLOOD));
        abils.add(new MultiAbilityManager.MultiAbilityInfoSub("Mangle", (Element)Element.BLOOD));
        abils.add(new MultiAbilityManager.MultiAbilityInfoSub("Puppet", (Element)Element.BLOOD));
        abils.add(new MultiAbilityManager.MultiAbilityInfoSub("Slam", (Element)Element.BLOOD));
        return abils;
    }

    public boolean isEnabled() {
        return false;
    }
}

