/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.fire.Jets;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TurboJet
extends FireAbility
implements AddonAbility,
ComboAbility {
    @Attribute(value="Speed")
    private double speed;
    @Attribute(value="Cooldown")
    private long cooldown;
    private double normal;
    private Jets jets;

    public TurboJet(Player player) {
        super(player);
        if (player.getLocation().getBlock().isLiquid()) {
            return;
        }
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        this.speed = ProjectAddons.instance.getConfig().getDouble("Combos.Fire.TurboJet.Speed");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Fire.TurboJet.Cooldown");
        this.normal = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Jets.FlySpeed");
        this.jets = !TurboJet.hasAbility((Player)player, Jets.class) ? new Jets(player, this) : (Jets)TurboJet.getAbility((Player)player, Jets.class);
        ParticleEffect.EXPLOSION_NORMAL.display(player.getLocation(), 1);
        this.start();
    }

    public void progress() {
        this.jets.setFlySpeed(this.speed);
        this.speed -= 0.025;
        if (this.speed <= this.normal) {
            this.jets.setFlySpeed(this.normal);
            this.bPlayer.addCooldown((Ability)this);
            this.remove();
            return;
        }
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "TurboJet";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public Object createNewComboInstance(Player player) {
        return new TurboJet(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("Jets", ClickType.SHIFT_UP));
        return combo;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Release massive power all at once to make your jets go turbo speed!";
    }

    public String getInstructions() {
        return "HeatControl (Hold sneak) > Jets (Release sneak)";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Fire.TurboJet.Enabled");
    }
}

