/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.fire.TurboJet;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Jets
extends FireAbility
implements AddonAbility {
    @Attribute(value="FlySpeed")
    private double flySpeed;
    @Attribute(value="HoverSpeed")
    private double hoverSpeed;
    @Attribute(value="DamageThreshold")
    private double dmgThreshold;
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Cooldown")
    private long cooldown;
    private float oSpeed;
    private double health;
    private boolean hovering;
    private boolean gliding;
    private TurboJet source;

    public Jets(Player player) {
        this(player, null);
    }

    public Jets(Player player, TurboJet source) {
        super(player);
        if (source == null && player.isOnGround()) {
            return;
        }
        this.source = source;
        this.oSpeed = player.getFlySpeed();
        this.health = player.getHealth();
        this.flySpeed = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Jets.FlySpeed");
        this.hoverSpeed = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Jets.HoverSpeed");
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.Jets.Duration");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.Jets.Cooldown");
        this.dmgThreshold = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Jets.DamageThreshold");
        double speedThreshold = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Jets.SpeedThreshold");
        if (source != null) {
            this.gliding = true;
            this.hovering = false;
        } else if (player.isSprinting() || player.getVelocity().length() > speedThreshold && Math.abs(player.getVelocity().angle(player.getEyeLocation().getDirection())) < 30.0f) {
            this.gliding = true;
            this.hovering = false;
        } else {
            this.gliding = false;
            this.hovering = true;
        }
        this.flightHandler.createInstance(player, this.getName());
        player.setAllowFlight(true);
        player.setFlySpeed((float)this.hoverSpeed);
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.isOnGround()) {
            this.remove();
            return;
        }
        if (this.player.getLocation().getBlock().isLiquid()) {
            this.remove();
            return;
        }
        if (this.duration > 0L && this.getStartTime() + this.duration < System.currentTimeMillis()) {
            this.remove();
            return;
        }
        if (this.player.getHealth() < this.health - this.dmgThreshold) {
            this.remove();
            return;
        }
        Vector pDirection = null;
        if (this.hovering) {
            this.player.setFlying(true);
            this.player.setGliding(false);
            this.player.setVelocity(this.player.getVelocity().add(new Vector(0.0, -0.015, 0.0)));
            pDirection = new Vector(0.0, -0.4, 0.0);
        } else if (this.gliding) {
            this.player.setGliding(true);
            this.player.setFlying(false);
            Vector velocity = this.player.getEyeLocation().getDirection().clone().normalize().multiply(this.flySpeed);
            if (this.player.getVelocity().getY() < 0.0) {
                velocity.add(this.player.getVelocity().multiply(0.2));
            }
            this.player.setVelocity(velocity);
            pDirection = this.player.getEyeLocation().getDirection().clone().normalize().multiply(-0.4);
        } else {
            this.remove();
            return;
        }
        for (int i = 0; i < 4; ++i) {
            Location p = this.player.getLocation().clone().add(pDirection.clone().multiply(i));
            ProjectAddons.instance.getMethods().playDynamicFireParticles(this.player, p, 4 - i, 0.3 - (double)(i / 10), 0.04, 0.3 - (double)(i / 10));
        }
        Jets.playFirebendingSound((Location)this.player.getLocation());
    }

    public void remove() {
        super.remove();
        this.flightHandler.removeInstance(this.player, this.getName());
        this.player.setFallDistance(0.0f);
        this.player.setFlySpeed(this.oSpeed);
        double durationUsed = System.currentTimeMillis() - this.getStartTime();
        if (durationUsed < (double)this.duration) {
            double percent = durationUsed / (double)this.duration;
            this.cooldown = (long)((double)this.cooldown * percent);
        }
        this.bPlayer.addCooldown((Ability)this);
    }

    public void clickFunction() {
        if (this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (this.hovering) {
            this.hovering = false;
            this.gliding = true;
        } else if (this.source == null || this.source.isRemoved()) {
            this.hovering = true;
            this.gliding = false;
        }
    }

    public void setFlySpeed(double speed) {
        this.flySpeed = Math.abs(speed);
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Jets";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.Jets.Enabled");
    }

    public String getDescription() {
        return "Create jets of flames from your feet to hover off the ground or fly through the sky. Activating the ability while moving fast enough and looking in the direction you're moving will automatically put you in flying mode!";
    }

    public String getInstructions() {
        return "Left click to activate, Left click to switch modes, and Sneak + Left click to cancel ability";
    }
}

