/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.ElementalAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.util.Vector;

public class FlameBreath
extends FireAbility
implements AddonAbility,
ComboAbility,
Listener {
    @Attribute(value="FireTicks")
    private int fireTick;
    @Attribute(value="Range")
    private double range;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="BurnGround")
    private boolean burnGround;
    @Attribute(value="BurnEntities")
    private boolean burnEntities;
    @Attribute(value="EasterEgg")
    private boolean rainbow;
    @Attribute(value="Duration")
    private long duration;
    private Set<Breath> breaths;
    private Queue<Color> colors;

    public FlameBreath(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        this.setFields();
        this.start();
    }

    private void setFields() {
        this.fireTick = ProjectAddons.instance.getConfig().getInt("Combos.Fire.FlameBreath.FireTick");
        this.range = ProjectAddons.instance.getConfig().getDouble("Combos.Fire.FlameBreath.Range");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Combos.Fire.FlameBreath.Damage");
        this.burnGround = ProjectAddons.instance.getConfig().getBoolean("Combos.Fire.FlameBreath.Burn.Ground");
        this.burnEntities = ProjectAddons.instance.getConfig().getBoolean("Combos.Fire.FlameBreath.Burn.Entities");
        this.rainbow = ProjectAddons.instance.getConfig().getBoolean("Combos.Fire.FlameBreath.Rainbow");
        this.duration = ProjectAddons.instance.getConfig().getLong("Combos.Fire.FlameBreath.Duration");
        this.breaths = new HashSet<Breath>();
        int turnsPerColor = 8;
        int amount = Color.values().length * turnsPerColor;
        this.colors = new LinkedList<Color>();
        for (int i = 0; i < amount; ++i) {
            int index = (int)Math.floor(i / turnsPerColor);
            this.colors.add(Color.values()[index]);
        }
    }

    public long getCooldown() {
        return ProjectAddons.instance.getConfig().getLong("Combos.Fire.FlameBreath.Cooldown");
    }

    public Location getLocation() {
        return this.player.getEyeLocation();
    }

    public List<Location> getLocations() {
        ArrayList<Location> locList = new ArrayList<Location>();
        for (Breath b : this.breaths) {
            locList.add(b.getLocation());
        }
        return locList;
    }

    public String getName() {
        return "FlameBreath";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (!this.bPlayer.canBendIgnoreBinds((CoreAbility)this)) {
            this.remove();
            return;
        }
        if (System.currentTimeMillis() > this.getStartTime() + this.duration) {
            this.remove();
            return;
        }
        Color c = this.colors.poll();
        this.colors.add(c);
        Breath b = new Breath(this.player, c);
        this.breaths.add(b);
        ArrayList<Breath> removal = new ArrayList<Breath>();
        for (Breath breath : this.breaths) {
            if (breath.advanceLocation()) {
                double offset = 0.1 * breath.getLocation().distance(this.player.getEyeLocation());
                int amount = (int)Math.ceil(breath.getLocation().distance(this.player.getEyeLocation()));
                if (this.rainbow && this.player.hasPermission("bending.ability.FlameBreath.rainbow")) {
                    GeneralMethods.displayColoredParticle((String)breath.getColor().getHex(), (Location)breath.getLocation(), (int)amount, (double)offset, (double)offset, (double)offset);
                } else {
                    ProjectAddons.instance.getMethods().playDynamicFireParticles(this.player, breath.getLocation(), amount, offset, offset, offset);
                }
                if (Math.random() > 0.6) {
                    FlameBreath.playFirebendingSound((Location)breath.getLocation());
                }
                for (Entity entity : GeneralMethods.getEntitiesAroundPoint((Location)breath.getLocation(), (double)(offset * 2.5))) {
                    if (entity instanceof LivingEntity && entity.getEntityId() != this.player.getEntityId()) {
                        DamageHandler.damageEntity((Entity)entity, (double)this.damage, (Ability)this);
                        entity.setVelocity(breath.getDirection().clone());
                        if (!this.burnEntities) continue;
                        entity.setFireTicks(this.fireTick + 10);
                        continue;
                    }
                    if (!(entity instanceof Item)) continue;
                    entity.setFireTicks(this.fireTick + 40);
                }
                if (!this.burnGround || !GeneralMethods.isSolid((Block)breath.getLocation().getBlock().getRelative(BlockFace.DOWN)) || breath.getLocation().getBlock().getType() == Material.FIRE) continue;
                new TempBlock(breath.getLocation().getBlock(), Material.FIRE).setRevertTime((long)(this.fireTick / 20 * 1000 + 1000));
                continue;
            }
            removal.add(breath);
        }
        this.breaths.removeAll(removal);
    }

    public Object createNewComboInstance(Player player) {
        return new FlameBreath(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_UP));
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_UP));
        combo.add(new ComboManager.AbilityInformation("HeatControl", ClickType.SHIFT_DOWN));
        return combo;
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Fire.FlameBreath.Enabled");
    }

    public String getDescription() {
        return "The greatest firebenders were able to breath fire! These firebenders learned from the majestic dragons that are now extinct, but fortunately they passed on their sacred bending arts to you! By breathing super-hot air, you can cause it to spontaneously combust, burning all entities and the ground within its radius!";
    }

    public String getInstructions() {
        return "HeatControl (double tap sneak) > HeatControl (hold sneak)";
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public class Breath {
        protected Player player;
        protected Vector dir;
        protected Location start;
        protected Location loc;
        protected Color color;

        public Breath(Player player, Color color) {
            this.player = player;
            this.start = player.getEyeLocation().clone();
            this.dir = this.start.getDirection().clone().normalize().multiply(0.5);
            this.loc = this.start.clone();
            this.color = color;
        }

        public boolean advanceLocation() {
            this.loc = this.loc.add(this.dir);
            if (GeneralMethods.isSolid((Block)this.loc.getBlock())) {
                return false;
            }
            if (ElementalAbility.isWater((Block)this.loc.getBlock())) {
                return false;
            }
            if (GeneralMethods.isRegionProtectedFromBuild((Player)this.player, (Location)this.loc)) {
                return false;
            }
            return !(this.start.distance(this.loc) > FlameBreath.this.range);
        }

        public Vector getDirection() {
            return this.dir;
        }

        public Location getLocation() {
            return this.loc;
        }

        public Location getStart() {
            return this.start;
        }

        public Color getColor() {
            return this.color;
        }
    }

    private static enum Color {
        RED("#ff0000"),
        ORANGE("#ff6600"),
        YELLOW("#ffff00"),
        GREEN("#00ff00"),
        CYAN("#00ffff"),
        BLUE("#0000ff"),
        PURPLE("#ff00ff");

        private String hex;

        private Color(String hex) {
            this.hex = hex;
        }

        public String getHex() {
            return this.hex;
        }
    }
}

