/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FireDisc
extends FireAbility
implements AddonAbility {
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Range")
    private double range;
    @Attribute(value="DropCutBlocks")
    private boolean drop;
    @Attribute(value="Controllable")
    private boolean control;
    @Attribute(value="Cooldown")
    private long cooldown;
    private boolean revert;
    private double currRange = 0.0;
    private Location loc;
    private Vector direction;

    public FireDisc(Player player) {
        super(player);
        this.loc = player.getEyeLocation();
        this.direction = player.getLocation().getDirection();
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.FireDisc.Damage");
        this.range = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.FireDisc.Range");
        this.control = ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.FireDisc.Controllable");
        this.revert = ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.FireDisc.RevertCutBlocks");
        this.drop = ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.FireDisc.DropCutBlocks");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.FireDisc.Cooldown");
        if (player.hasPermission("bending.fire.bluefire")) {
            this.damage *= 1.5;
        }
        if (this.bPlayer.isAvatarState()) {
            this.control = true;
            this.cooldown = 0L;
        }
        this.bPlayer.addCooldown((Ability)this);
        this.start();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.loc;
    }

    public String getName() {
        return "FireDisc";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        if (this.player == null) {
            this.remove();
            return;
        }
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.control) {
            this.direction = this.direction.add(this.player.getLocation().getDirection());
        }
        FireDisc.playFirebendingSound((Location)this.loc);
        this.loc = this.loc.add(this.direction.normalize());
        if (this.currRange >= this.range) {
            this.remove();
            return;
        }
        this.currRange += 1.0;
        if (GeneralMethods.isSolid((Block)this.loc.getBlock())) {
            if (!this.cutBlock(this.loc.getBlock())) {
                this.remove();
                return;
            }
            ItemStack is = new ItemStack(this.loc.getBlock().getType());
            if (this.revert) {
                new TempBlock(this.loc.getBlock(), Material.AIR);
            } else {
                this.loc.getBlock().setType(Material.AIR);
            }
            if (this.drop) {
                this.loc.getWorld().dropItemNaturally(this.loc, is);
            }
        }
        if (this.loc.getBlock().isLiquid()) {
            this.remove();
            return;
        }
        Vector normal = GeneralMethods.getOrthogonalVector((Vector)this.direction, (double)0.0, (double)1.0);
        for (double r = 0.0; r < 1.0; r += 0.2) {
            for (double theta = 0.0; theta < Math.PI * 2; theta += Math.PI / (r * 12.0)) {
                Vector ortho = GeneralMethods.getOrthogonalVector((Vector)normal, (double)Math.toDegrees(theta), (double)r);
                ProjectAddons.instance.getMethods().playDynamicFireParticles(this.player, this.loc.clone().add(ortho), 2, 0.03, 0.0, 0.03);
            }
        }
        for (Entity entity : GeneralMethods.getEntitiesAroundPoint((Location)this.loc, (double)1.5)) {
            if (!(entity instanceof LivingEntity) || entity.getEntityId() == this.player.getEntityId()) continue;
            DamageHandler.damageEntity((Entity)entity, (Player)this.player, (double)this.damage, (Ability)this);
            this.remove();
            return;
        }
    }

    public boolean cutBlock(Block b) {
        return ProjectAddons.instance.getConfig().getStringList("Abilities.Fire.FireDisc.CuttableBlocks").contains(b.getType().toString());
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.FireDisc.Enabled");
    }

    public String getDescription() {
        return "Throw a spinning disc of fire that can cut through some blocks or your enemies!";
    }

    public String getInstructions() {
        return "Left Click";
    }
}

