/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.CombustionAbility;
import com.projectkorra.projectkorra.ability.ElementalAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Explode
extends CombustionAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.Explode.Cooldown");
    @Attribute(value="Damage")
    private double damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Explode.Damage");
    @Attribute(value="Radius")
    private double radius = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Explode.Radius");
    @Attribute(value="Knockback")
    private double knockback = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Explode.Knockback");
    @Attribute(value="Range")
    private double range = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Explode.Range");
    private Location center;

    public Explode(Player player) {
        super(player);
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.isSneaking()) {
            this.center = GeneralMethods.getTargetedLocation((Player)this.player, (double)this.range, (Material[])ElementalAbility.getTransparentMaterials());
            ParticleEffect.CRIT.display(this.center, 3, 0.3, 0.3, 0.3);
            this.player.getWorld().playSound(this.center, Sound.ENTITY_CREEPER_PRIMED, 0.2f, 8.0f);
        } else if (this.center != null) {
            double offset = this.radius / 2.0;
            ProjectAddons.instance.getMethods().playDynamicFireParticles(this.player, this.center, 7, offset, offset, offset);
            ParticleEffect.CRIT.display(this.center, 6, offset, offset, offset);
            ParticleEffect.EXPLOSION_HUGE.display(this.center, 1);
            this.player.getWorld().playSound(this.center, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 3.0f);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.center, (double)this.radius)) {
                if (!(e instanceof LivingEntity)) continue;
                Vector direction = GeneralMethods.getDirection((Location)this.center, (Location)((LivingEntity)e).getEyeLocation()).normalize().multiply(this.knockback);
                DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
                e.setVelocity(direction);
            }
            this.remove();
        }
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Explode";
    }

    public Location getLocation() {
        return this.center;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.Explode.Enabled");
    }

    public String getDescription() {
        return "Cause a spontaneous explosion where you are looking! Big boom!";
    }

    public String getInstructions() {
        return "Hold sneak to aim, release sneak to explode!";
    }
}

