/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.LightningAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.HashSet;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Electrify
extends LightningAbility
implements AddonAbility {
    private static Set<Block> electrified = new HashSet<Block>();
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="DamageInWater")
    private double waterdmg;
    @Attribute(value="Slowness")
    private int slowness;
    @Attribute(value="Weakness")
    private int weakness;
    private int spread;
    private Block block;
    private Location center;

    public Electrify(Player player, Block block, boolean direct) {
        this(player, block, direct, 3);
    }

    public Electrify(Player player, Block block, boolean direct, int spread) {
        super(player);
        if (!ProjectAddons.instance.getConfig().getStringList("Properties.MetallicBlocks").contains(block.getType().toString()) && block.getType() != Material.WATER) {
            return;
        }
        if (electrified.contains(block)) {
            return;
        }
        electrified.add(block);
        this.block = block;
        this.center = block.getLocation().add(0.5, 0.5, 0.5);
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.Electrify.Cooldown");
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.Electrify.Duration");
        this.waterdmg = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.Electrify.DamageInWater");
        this.slowness = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.Electrify.Slowness") + 1;
        this.weakness = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.Electrify.Weakness") + 1;
        this.spread = spread;
        if (direct) {
            this.bPlayer.addCooldown((Ability)this);
        }
        this.start();
    }

    public void progress() {
        if (this.getStartTime() + this.duration <= System.currentTimeMillis()) {
            this.remove();
            return;
        }
        if (!ProjectAddons.instance.getConfig().getStringList("Properties.MetallicBlocks").contains(this.block.getType().toString()) && this.block.getType() != Material.WATER) {
            this.remove();
            return;
        }
        if (this.spread > 0) {
            BlockFace[] faces;
            for (BlockFace face : faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST}) {
                Block b = this.block.getRelative(face);
                new Electrify(this.player, b, false, this.spread - 1);
            }
        }
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.center, (double)1.0)) {
            if (!(e instanceof LivingEntity)) continue;
            if (this.block.getType() == Material.WATER && e.getLocation().getBlock().equals(this.block)) {
                DamageHandler.damageEntity((Entity)e, (double)this.waterdmg, (Ability)this);
            } else if (!e.getLocation().getBlock().equals(this.block.getRelative(BlockFace.UP))) continue;
            if (e instanceof Player) {
                BendingPlayer bp = BendingPlayer.getBendingPlayer((Player)((Player)e));
                if (bp == null || bp.canLightningbend()) continue;
                ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, this.slowness), true);
                ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 10, this.weakness), true);
                continue;
            }
            ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, this.slowness), true);
            ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 10, this.weakness), true);
        }
        if (Math.random() < 0.15) {
            ProjectAddons.instance.getMethods().playLightningParticles(this.center, 1, 0.5, 0.5, 0.5);
            Electrify.playLightningbendingSound((Location)this.center);
        }
    }

    public void remove() {
        super.remove();
        new BukkitRunnable(){

            public void run() {
                electrified.remove(Electrify.this.block);
            }
        }.runTaskLater((Plugin)ProjectAddons.instance, 80L);
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Electrify";
    }

    public Location getLocation() {
        return this.center;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.Electrify.Enabled");
    }

    public String getDescription() {
        return "Electrify water and metallic blocks to slow and weaken entities! Entities in electrified water will also take damage! Lightningbenders are immune to the slowness and weakness, but still take damage in water.";
    }

    public String getInstructions() {
        return "Right click a block!";
    }
}

