/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.CombustionAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.object.HorizontalVelocityTracker;
import com.projectkorra.projectkorra.util.ActionBar;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import com.projectkorra.projectkorra.util.TempBlock;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.util.HexColor;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class CombustBeam
extends CombustionAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="MinChargeTime")
    private long minChargeTime;
    @Attribute(value="MaxChargeTime")
    private long maxChargeTime;
    @Attribute(value="Range")
    private double range;
    @Attribute(value="MinAngle")
    private double minAngle;
    @Attribute(value="MaxAngle")
    private double maxAngle;
    @Attribute(value="MinPower")
    private double minPower;
    @Attribute(value="MaxPower")
    private double maxPower;
    private double power;
    private double rotation;
    private double angleCheck;
    private double health;
    private long chargeTime;
    private int counter;
    private boolean charging;
    private boolean charged;
    private Location curr;
    private Vector direction;

    public CombustBeam(Player player) {
        super(player);
        if (CombustBeam.hasAbility((Player)player, CombustBeam.class)) {
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.CombustBeam.Cooldown");
        this.minChargeTime = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.CombustBeam.Minimum.ChargeTime");
        this.maxChargeTime = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.CombustBeam.Maximum.ChargeTime");
        this.minAngle = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.Minimum.Angle");
        this.maxAngle = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.Maximum.Angle");
        this.minPower = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.Minimum.Power");
        this.maxPower = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.Maximum.Power");
        this.range = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.Range");
        this.health = player.getHealth();
        this.charging = true;
        this.charged = false;
        this.rotation = 0.0;
        this.counter = 0;
        this.start();
    }

    public void progress() {
        block16: {
            Vector to;
            block14: {
                block15: {
                    if (!this.player.isOnline() || this.player.isDead()) {
                        this.remove();
                        return;
                    }
                    if (!this.charging) break block14;
                    if (!this.bPlayer.getBoundAbilityName().equalsIgnoreCase("CombustBeam")) {
                        this.remove();
                        return;
                    }
                    if (!this.charged && !this.player.isSneaking()) {
                        this.remove();
                        return;
                    }
                    if (this.charged && !this.player.isSneaking()) {
                        this.charging = false;
                        this.curr = this.player.getEyeLocation();
                        this.direction = this.player.getEyeLocation().getDirection().clone().normalize();
                        if (this.player.getHealth() < this.health) {
                            DamageHandler.damageEntity((Entity)this.player, (double)ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.CombustBeam.InterruptedDamage"), (Ability)this);
                            this.explode();
                            return;
                        }
                        return;
                    }
                    this.player.getWorld().playSound(this.player.getEyeLocation(), Sound.ENTITY_WITHER_AMBIENT, 0.01f, 0.6f);
                    if (this.getStartTime() + this.maxChargeTime > System.currentTimeMillis()) break block15;
                    this.chargeTime = this.maxChargeTime;
                    this.angleCheck = this.minAngle;
                    this.power = this.maxPower;
                    this.charged = true;
                    GeneralMethods.displayColoredParticle((String)"ff2424", (Location)this.player.getEyeLocation().add(this.player.getEyeLocation().getDirection().normalize()), (int)1, (double)0.4, (double)0.4, (double)0.4);
                    this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, 5), true);
                    ActionBar.sendActionBar((String)(ChatColor.RED + "100%"), (Player[])new Player[]{this.player});
                    break block16;
                }
                if (this.getStartTime() + this.minChargeTime > System.currentTimeMillis()) break block16;
                this.chargeTime = System.currentTimeMillis() - this.getStartTime() - this.minChargeTime;
                double percent = (double)this.chargeTime / (double)(this.maxChargeTime - this.minChargeTime);
                this.angleCheck = this.maxAngle - (this.maxAngle - this.minAngle) * percent;
                this.power = this.minPower + (this.maxPower - this.minPower) * percent;
                this.charged = true;
                ActionBar.sendActionBar((String)(ChatColor.RED + Math.round(percent * 100.0) + "%"), (Player[])new Player[]{this.player});
                HexColor color = new HexColor((int)(255.0 * percent), 36, 36);
                GeneralMethods.displayColoredParticle((String)color.getHexcode(), (Location)this.player.getEyeLocation().add(this.player.getEyeLocation().getDirection().normalize()), (int)1, (double)0.4, (double)0.4, (double)0.4);
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, (int)(5.0 * percent)), true);
                break block16;
            }
            if (this.player.isSneaking() && (double)Math.abs(this.direction.angle(to = this.player.getEyeLocation().getDirection().clone().normalize().multiply(0.3))) < this.angleCheck) {
                this.direction.add(to);
            }
            this.direction.normalize();
            int j = 0;
            while ((double)j < this.power) {
                if (this.player.getEyeLocation().distance(this.curr) >= this.range) {
                    this.explode();
                    return;
                }
                this.curr.add(this.direction);
                if (!this.curr.getBlock().isPassable()) {
                    this.explode();
                    return;
                }
                if (this.curr.getBlock().getType() == Material.WATER) {
                    for (Block b : GeneralMethods.getBlocksAroundPoint((Location)this.curr, (double)this.power)) {
                        if (b.getType() != Material.WATER) continue;
                        new TempBlock(b, Material.AIR).setRevertTime(100000L);
                    }
                    this.explode();
                    return;
                }
                GeneralMethods.displayColoredParticle((String)"fefefe", (Location)this.curr, (int)3, (double)0.1, (double)0.1, (double)0.1);
                for (int i = 0; i < 2; ++i) {
                    Vector v = GeneralMethods.getOrthogonalVector((Vector)this.direction, (double)(this.rotation + (double)(180 * i)), (double)0.4);
                    Location p = this.curr.clone().add(v);
                    GeneralMethods.displayColoredParticle((String)"ededed", (Location)p);
                }
                this.rotation += 10.0;
                if (this.counter % 6 == 0) {
                    ParticleEffect.EXPLOSION_LARGE.display(this.curr, 1);
                    CombustBeam.playCombustionSound((Location)this.curr);
                }
                ++this.counter;
                for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.curr, (double)1.0)) {
                    if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                    this.explode();
                    return;
                }
                ++j;
            }
        }
    }

    public void explode() {
        if (!this.charging) {
            this.player.getWorld().createExplosion(this.curr, (float)this.power, true);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.curr, (double)this.power)) {
                if (!(e instanceof LivingEntity)) continue;
                double knockback = this.power / (0.3 + e.getLocation().distance(this.curr));
                Vector v = GeneralMethods.getDirection((Location)this.curr, (Location)e.getLocation().add(0.0, 1.0, 0.0)).normalize().multiply(knockback);
                e.setVelocity(v);
                new HorizontalVelocityTracker(e, this.player, 4000L, (Ability)this);
            }
            this.remove();
        }
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "CombustBeam";
    }

    public Location getLocation() {
        return this.curr;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.CombustBeam.Enabled");
    }

    public String getDescription() {
        return "Fire a beam of concentrated energy from your forehead after charging. Longer charge times increase power, speed, and decrease how controllable the beam is. Explodes when hitting blocks and entities. Evaporates nearby water on explosion. Collides with some other abilities.";
    }

    public String getInstructions() {
        return "Hold sneak to begin charging. Release anytime you see particles in front of you to launch the beam. Hold sneak again to direct the beam to some degree.";
    }
}

