/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.ability.LightningAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ActionBar;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ChargeBolt
extends LightningAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="ChargeTime")
    private long chargeTime;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Range")
    private double boltRange;
    @Attribute(value="Radius")
    private double blastRadius;
    @Attribute(value="Speed")
    private int speed;
    @Attribute(value="DischargeBoltCount")
    private int dischargeBolts;
    private Set<Bolt> bolts;

    public ChargeBolt(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        this.chargeTime = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.ChargeBolt.ChargeTime");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.ChargeBolt.Damage");
        this.boltRange = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.ChargeBolt.BoltRange");
        this.blastRadius = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.ChargeBolt.BlastRadius");
        this.speed = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.ChargeBolt.Speed");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.ChargeBolt.Cooldown");
        this.dischargeBolts = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.ChargeBolt.DischargeBoltCount");
        this.bolts = new HashSet<Bolt>(this.dischargeBolts);
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.isSneaking() && System.currentTimeMillis() > this.getStartTime() + this.chargeTime) {
            ProjectAddons.instance.getMethods().playLightningParticles(GeneralMethods.getMainHandLocation((Player)this.player), 2, 0.1, 0.1, 0.1);
            if (Math.random() < 0.3) {
                ChargeBolt.playLightningbendingSound((Location)this.player.getEyeLocation());
            }
        } else if (!this.player.isSneaking() && System.currentTimeMillis() > this.getStartTime() + this.chargeTime) {
            this.discharge();
        } else {
            if (!this.player.isSneaking() && System.currentTimeMillis() < this.getStartTime() + this.chargeTime) {
                this.remove();
                return;
            }
            if (System.currentTimeMillis() < this.getStartTime() + this.chargeTime) {
                return;
            }
        }
        HashSet<Bolt> remove = new HashSet<Bolt>();
        block0: for (Bolt bolt : this.bolts) {
            for (int i = 0; i < this.speed; ++i) {
                if (bolt.advance()) continue;
                remove.add(bolt);
                continue block0;
            }
        }
        this.bolts.removeAll(remove);
        if (this.bolts.isEmpty() && this.dischargeBolts < 1) {
            this.remove();
            return;
        }
    }

    private void discharge() {
        this.bPlayer.addCooldown((Ability)this);
        Location loc = this.player.getLocation().add(0.0, 1.0, 0.0);
        Random rand = new Random();
        for (int i = 0; i < this.dischargeBolts; ++i) {
            float yaw = this.player.getEyeLocation().getYaw() + (float)rand.nextInt(60) - 30.0f;
            float pitch = this.player.getEyeLocation().getPitch() + (float)rand.nextInt(46) - 23.0f;
            loc.setYaw(yaw);
            loc.setPitch(pitch);
            this.bolts.add(new Bolt(loc, this.blastRadius, this.speed));
        }
        this.dischargeBolts = 0;
    }

    public void bolt() {
        if (this.dischargeBolts < 1) {
            return;
        }
        if (System.currentTimeMillis() < this.getStartTime() + this.chargeTime) {
            return;
        }
        Location loc = GeneralMethods.getMainHandLocation((Player)this.player);
        loc.setDirection(this.player.getEyeLocation().getDirection());
        this.bolts.add(new Bolt(loc, this.boltRange, this.speed));
        --this.dischargeBolts;
        if (this.dischargeBolts < 1) {
            this.bPlayer.addCooldown((Ability)this);
        } else {
            ActionBar.sendActionBar((String)(ChatColor.DARK_RED + "" + this.dischargeBolts + " bolts remaining"), (Player[])new Player[]{this.player});
        }
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "ChargeBolt";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Charge up your electricity and shoot bolts of lightning! They can be shot one at a time or discharged around you all at once.";
    }

    public String getInstructions() {
        return "Sneak to charge, click to shoot one at a time or release sneak to discharge.";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.ChargeBolt.Enabled");
    }

    private class Bolt {
        private Location loc;
        private Location start;
        private double range;
        private Random rand;

        private Bolt(Location start, double range, double speed) {
            this.start = start.clone();
            this.loc = start.clone();
            this.loc.getDirection().normalize();
            this.range = range * range;
            this.rand = new Random();
        }

        private boolean advance() {
            this.loc.setYaw(this.start.getYaw() + (float)(this.rand.nextInt(16) - 8));
            this.loc.setPitch(this.start.getPitch() + (float)(this.rand.nextInt(16) - 8));
            this.loc.add(this.loc.getDirection());
            if (this.loc.distanceSquared(this.start) >= this.range) {
                return false;
            }
            if (!this.loc.getBlock().isPassable()) {
                return false;
            }
            ProjectAddons.instance.getMethods().playLightningParticles(this.loc, 5, 0.1, 0.1, 0.1);
            FireAbility.playLightningbendingSound((Location)this.loc);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.loc, (double)0.62)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == ChargeBolt.this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (double)ChargeBolt.this.damage, (Ability)ChargeBolt.this);
                ((LivingEntity)e).setNoDamageTicks(0);
                return false;
            }
            return true;
        }
    }
}

