/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.fire;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.FireAbility;
import com.projectkorra.projectkorra.ability.LightningAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.List;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.fire.Electrify;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ArcSpark
extends LightningAbility
implements AddonAbility {
    @Attribute(value="Speed")
    private int speed = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.ArcSpark.Speed");
    @Attribute(value="Length")
    private int length = ProjectAddons.instance.getConfig().getInt("Abilities.Fire.ArcSpark.Length");
    @Attribute(value="Damage")
    private double damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Fire.ArcSpark.Damage");
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Cooldown")
    private long cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.ArcSpark.Cooldown");
    private long charge;
    private long chargedTill;
    private boolean shoot = false;
    private boolean charged = false;
    private List<String> attractive;

    public ArcSpark(Player player) {
        super(player);
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.ArcSpark.Duration");
        this.charge = ProjectAddons.instance.getConfig().getLong("Abilities.Fire.ArcSpark.ChargeTime");
        this.attractive = ProjectAddons.instance.getConfig().getStringList("Properties.MetallicBlocks");
        this.chargedTill = System.currentTimeMillis();
        this.start();
    }

    public void progress() {
        if (this.player.isDead() || !this.player.isOnline() || !this.player.isSneaking() || !this.bPlayer.getBoundAbilityName().equalsIgnoreCase("ArcSpark")) {
            this.remove();
            return;
        }
        if (!this.charged) {
            long checkTime = this.getStartTime() + this.charge - System.currentTimeMillis();
            if (checkTime <= 0L) {
                this.charged = true;
            } else {
                ProjectAddons.instance.getMethods().playLightningParticles(this.player.getLocation().add(0.0, 1.0, 0.0), 2, 0.36, 0.21, 0.36);
            }
            this.chargedTill = System.currentTimeMillis();
            this.player.getWorld().playSound(this.player.getEyeLocation(), Sound.ENTITY_CREEPER_PRIMED, 0.05f, 0.5f);
        } else if (this.charged && !this.shoot) {
            ProjectAddons.instance.getMethods().playLightningParticles(GeneralMethods.getMainHandLocation((Player)this.player), 1, 0.001, 0.001, 0.001);
            this.chargedTill = System.currentTimeMillis();
            this.player.getWorld().playSound(this.player.getEyeLocation(), Sound.ENTITY_CREEPER_PRIMED, 0.05f, 0.5f);
        } else if (this.charged && this.shoot) {
            if (this.chargedTill + this.duration < System.currentTimeMillis()) {
                this.remove();
                return;
            }
            Location hand = GeneralMethods.getMainHandLocation((Player)this.player);
            hand.setDirection(this.player.getEyeLocation().getDirection());
            Arc arc = new Arc(hand);
            for (int i = 0; i < this.speed * this.length; ++i) {
                arc.run(this);
            }
        }
    }

    public void remove() {
        super.remove();
        if (this.charged && this.shoot) {
            this.bPlayer.addCooldown((Ability)this);
        }
    }

    public void shoot() {
        if (this.charged) {
            this.shoot = true;
        }
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "ArcSpark";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Fire.ArcSpark.Enabled");
    }

    public String getInstructions() {
        return "Hold sneak to charge up and click when charged to shoot, but keep holding sneak!";
    }

    public String getDescription() {
        return "Shoots arcs of electricity in the direction you are looking, and the arcs are attracted to some blocks and entities! Hitting a metallic block or water will cause it to become electrified!";
    }

    class Arc {
        private boolean progressing = true;
        private Location loc;

        public Arc(Location loc) {
            this.loc = loc;
        }

        public void run(ArcSpark a) {
            if (!this.progressing) {
                return;
            }
            double shortest = Double.MAX_VALUE;
            Entity closest = null;
            Location to = null;
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.loc, (double)3.0)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == ArcSpark.this.player.getEntityId()) continue;
                double dist = this.loc.distance(e.getLocation().clone().add(0.0, 1.0, 0.0));
                if (dist <= 1.0) {
                    DamageHandler.damageEntity((Entity)e, (double)ArcSpark.this.damage, (Ability)a);
                    this.progressing = false;
                    return;
                }
                if (!(dist < shortest) && closest != null) continue;
                shortest = dist;
                closest = e;
                to = e.getLocation().clone().add(0.0, 1.0, 0.0);
            }
            if (closest == null) {
                for (Block b : GeneralMethods.getBlocksAroundPoint((Location)this.loc, (double)2.0)) {
                    Location center;
                    double dist;
                    if (b.isPassable() || !ArcSpark.this.attractive.contains(b.getType().toString()) || !((dist = this.loc.distance(center = b.getLocation().add(0.5, 0.5, 0.5))) < shortest)) continue;
                    shortest = dist;
                    to = center;
                }
            }
            Vector movement = null;
            movement = to != null ? GeneralMethods.getDirection((Location)this.loc, to) : new Vector(Math.random() / 5.0 - 0.1, Math.random() / 5.0 - 0.1, Math.random() / 5.0 - 0.1);
            double angle = movement.angle(this.loc.getDirection());
            if (angle < 60.0 && angle > -60.0) {
                this.loc.setDirection(this.loc.getDirection().add(movement));
            }
            this.loc.getDirection().normalize();
            this.loc.add(this.loc.getDirection().multiply(0.3));
            if (this.loc.getBlock().getType() == Material.WATER || ArcSpark.this.attractive.contains(this.loc.getBlock().getType().toString())) {
                if (Math.random() > 0.55) {
                    new Electrify(ArcSpark.this.player, this.loc.getBlock(), false);
                }
                this.progressing = false;
                return;
            }
            if (!this.loc.getBlock().isPassable()) {
                this.progressing = false;
                return;
            }
            ProjectAddons.instance.getMethods().playLightningParticles(this.loc, 1, 0.0, 0.0, 0.0);
            if (Math.random() < 0.15) {
                FireAbility.playLightningbendingSound((Location)this.loc);
            }
        }
    }
}

