/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ProjectKorra;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.MetalAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShrapnelShot
extends MetalAbility
implements AddonAbility {
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Cooldown")
    private long cooldown;
    private Item nugget;

    public ShrapnelShot(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown("Shrapnel")) {
            return;
        }
        if (!this.bPlayer.canBend((CoreAbility)this)) {
            return;
        }
        Material m = null;
        if (player.getInventory().contains(Material.IRON_NUGGET)) {
            m = Material.IRON_NUGGET;
        } else if (player.getInventory().contains(Material.GOLD_NUGGET)) {
            m = Material.GOLD_NUGGET;
        } else {
            return;
        }
        int slot = player.getInventory().first(m);
        ItemStack is = player.getInventory().getItem(slot);
        is.setAmount(is.getAmount() - 1);
        player.getInventory().setItem(slot, is);
        Location spawn = GeneralMethods.getRightSide((Location)player.getLocation(), (double)0.12).add(0.0, 1.3, 0.0);
        this.nugget = player.getWorld().dropItem(spawn, new ItemStack(m));
        this.nugget.setPickupDelay(10);
        this.nugget.setVelocity(player.getLocation().getDirection().clone().add(new Vector(0.0, 0.105, 0.0)).normalize().multiply(ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.Shrapnel.Shot.Speed")));
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.Shrapnel.Shot.Damage");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Shrapnel.Shot.Cooldown");
        this.bPlayer.addCooldown("Shrapnel", this.cooldown);
        this.start();
    }

    public ShrapnelShot(Player player, Vector direction, double speed) {
        super(player);
        if (!this.bPlayer.canBendIgnoreCooldowns((CoreAbility)this)) {
            return;
        }
        Material m = null;
        if (player.getInventory().contains(Material.IRON_NUGGET)) {
            m = Material.IRON_NUGGET;
        } else if (player.getInventory().contains(Material.GOLD_NUGGET)) {
            m = Material.GOLD_NUGGET;
        } else {
            return;
        }
        int slot = player.getInventory().first(m);
        ItemStack is = player.getInventory().getItem(slot);
        is.setAmount(is.getAmount() - 1);
        player.getInventory().setItem(slot, is);
        Location spawn = GeneralMethods.getRightSide((Location)player.getLocation(), (double)0.12).add(0.0, 1.3, 0.0);
        this.nugget = player.getWorld().dropItem(spawn, new ItemStack(m));
        this.nugget.setMetadata("shrapnel", (MetadataValue)new FixedMetadataValue((Plugin)ProjectKorra.plugin, (Object)0));
        this.nugget.setPickupDelay(10);
        this.nugget.setVelocity(direction.add(new Vector(0.0, 0.105, 0.0)).normalize().multiply(speed));
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.Shrapnel.Shot.Damage");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Shrapnel.Shot.Cooldown");
        this.start();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.nugget == null ? null : this.nugget.getLocation();
    }

    public String getName() {
        return "Shrapnel";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.nugget.isDead()) {
            this.remove();
            return;
        }
        if (this.nugget.isOnGround()) {
            this.remove();
            return;
        }
        ParticleEffect.CRIT.display(this.nugget.getLocation(), 1);
        this.player.getWorld().playSound(this.nugget.getLocation(), Sound.ITEM_TRIDENT_HIT, 0.2f, 1.0f);
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.nugget.getLocation(), (double)1.5)) {
            if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
            this.player.getWorld().playSound(e.getLocation(), Sound.BLOCK_ANVIL_PLACE, 0.4f, 1.0f);
            DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
            this.nugget.remove();
            this.remove();
            return;
        }
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Use your metalbending to throw nuggets of gold and iron like pieces of shrapnel, dealing damage when they hit entities. This requires that you have gold or iron nuggets in your inventory to launch!";
    }

    public String getInstructions() {
        return "Click to shoot a single piece of shrapnel at high velocity to the targeted location, click while sneaking to launch several shotgun-style.";
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.Shrapnel.Enabled");
    }
}

