/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class RockSlide
extends EarthAbility
implements AddonAbility,
ComboAbility {
    @Attribute(value="Speed")
    private double speed;
    @Attribute(value="Knockback")
    private double knockback;
    @Attribute(value="Knockup")
    private double knockup;
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Damage")
    private double damage;
    private Vector direction;
    private Set<FallingBlock> blocks;
    private double health;

    public RockSlide(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        Block b = this.getTopBlock(player.getLocation(), 1);
        if (!RockSlide.isEarthbendable((Material)b.getType(), (boolean)false, (boolean)true, (boolean)false)) {
            return;
        }
        this.blocks = new HashSet<FallingBlock>();
        this.speed = ProjectAddons.instance.getConfig().getDouble("Combos.Earth.RockSlide.Speed");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Earth.RockSlide.Cooldown");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Combos.Earth.RockSlide.Damage");
        this.direction = player.getEyeLocation().getDirection().clone().normalize().multiply(this.speed);
        this.knockback = ProjectAddons.instance.getConfig().getDouble("Combos.Earth.RockSlide.Knockback");
        this.knockup = ProjectAddons.instance.getConfig().getDouble("Combos.Earth.RockSlide.Knockup");
        this.direction.setY(0);
        this.health = player.getHealth();
        this.start();
    }

    public void remove() {
        super.remove();
        this.clearBlocks();
        this.bPlayer.addCooldown((Ability)this);
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.getHealth() < this.health) {
            this.remove();
            return;
        }
        Block b = this.getTopBlock(this.player.getLocation(), 3);
        if (b == null) {
            this.remove();
            return;
        }
        if (!RockSlide.isEarthbendable((Material)b.getType(), (boolean)false, (boolean)true, (boolean)false)) {
            this.remove();
            return;
        }
        if (this.player.isSneaking()) {
            this.remove();
            return;
        }
        this.direction = this.direction.add(this.player.getEyeLocation().getDirection().clone().normalize().multiply(0.086)).normalize().multiply(this.speed);
        double wHeight = (double)b.getY() + 2.1;
        double pHeight = this.player.getLocation().getY();
        double dHeight = wHeight - pHeight;
        this.direction.setY(dHeight * 0.2);
        this.player.setVelocity(this.direction);
        RockSlide.playEarthbendingSound((Location)this.player.getLocation());
        this.reloadBlocks();
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.player.getLocation(), (double)2.0)) {
            if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId() || this.blocks.contains(e)) continue;
            DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
            Vector knock = GeneralMethods.getDirection((Location)this.player.getLocation(), (Location)e.getLocation());
            knock.setY(this.knockup);
            knock.normalize().multiply(this.knockback);
            e.setVelocity(knock);
        }
    }

    private void clearBlocks() {
        for (FallingBlock fb : this.blocks) {
            fb.remove();
        }
        this.blocks.clear();
    }

    private void reloadBlocks() {
        if (!this.blocks.isEmpty()) {
            this.clearBlocks();
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Location loc = this.player.getLocation().clone().add((double)i, 0.0, (double)j);
                Block b = this.getTopBlock(loc, 2);
                if (b == null || !RockSlide.isEarthbendable((Material)b.getType(), (boolean)false, (boolean)true, (boolean)false) || !(loc = b.getLocation().add(0.5, 1.1, 0.5)).getBlock().isPassable()) continue;
                FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)this.offset(loc, 0.2, 0.2, 0.2), (Material)b.getType(), (BlockData)b.getBlockData());
                fb.setMetadata("rockslide", (MetadataValue)new FixedMetadataValue((Plugin)ProjectAddons.instance, (Object)0));
                fb.setDropItem(false);
                this.blocks.add(fb);
                if (!(Math.random() < 0.23)) continue;
                ParticleEffect.BLOCK_CRACK.display(fb.getLocation(), 2, 0.4, 0.4, 0.4, (Object)b.getBlockData());
            }
        }
        if (this.blocks.size() < ProjectAddons.instance.getConfig().getInt("Combos.Earth.RockSlide.RequiredRockCount")) {
            this.remove();
            return;
        }
    }

    private Block getTopBlock(Location loc, int range) {
        Block b = GeneralMethods.getTopBlock((Location)loc, (int)range);
        for (int i = 0; b.isPassable() && i < range; ++i) {
            b = b.getRelative(BlockFace.DOWN);
        }
        return b;
    }

    private Location offset(Location loc, double x, double y, double z) {
        double dx = Math.random() * x - x / 2.0;
        double dy = Math.random() * y - y / 2.0;
        double dz = Math.random() * z - z / 2.0;
        return loc.clone().add(dx, dy, dz);
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "RockSlide";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public Object createNewComboInstance(Player player) {
        return new RockSlide(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("Shockwave", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("Shockwave", ClickType.RIGHT_CLICK_BLOCK));
        combo.add(new ComboManager.AbilityInformation("EarthSmash", ClickType.SHIFT_UP));
        return combo;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Earth.RockSlide.Enabled");
    }

    public String getDescription() {
        return "Slide over the earth using loose chunks of rock";
    }

    public String getInstructions() {
        return "Shockwave (hold sneak) > Shockwave (right click block) > EarthSmash (release sneak)";
    }
}

