/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.MetalAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import java.util.Arrays;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class QuickWeld
extends MetalAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="RepairAmount")
    private int repairAmount;
    @Attribute(value="RepairInterval")
    private long repairCooldown;
    private ItemStack item;
    private Material[] metal_tools = new Material[]{Material.IRON_AXE, Material.IRON_BOOTS, Material.IRON_CHESTPLATE, Material.IRON_HELMET, Material.IRON_HOE, Material.IRON_LEGGINGS, Material.IRON_PICKAXE, Material.IRON_SHOVEL, Material.IRON_SWORD};

    public QuickWeld(Player player, ItemStack item) {
        super(player);
        if (item.getDurability() <= -249) {
            return;
        }
        if (!Arrays.asList(this.metal_tools).contains(item.getType())) {
            return;
        }
        this.item = item;
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.QuickWeld.Cooldown");
        this.repairAmount = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.QuickWeld.RepairAmount");
        this.repairCooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.QuickWeld.RepairInterval");
        this.start();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public String getName() {
        return "QuickWeld";
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        int val;
        if (this.player == null) {
            this.remove();
            return;
        }
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (this.bPlayer.isOnCooldown("QuickWeld Interval")) {
            return;
        }
        if (this.player.getInventory().containsAtLeast(new ItemStack(Material.IRON_INGOT), 1)) {
            this.player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.IRON_INGOT, 1)});
            val = this.item.getDurability() - this.repairAmount;
            if (val < -250) {
                val = -249;
            }
        } else {
            this.remove();
            return;
        }
        this.bPlayer.addCooldown("QuickWeld Interval", this.repairCooldown);
        this.item.setDurability((short)val);
        this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_ANVIL_USE, 0.5f, 1.0f);
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public String getDescription() {
        return "Advanced metalbenders can use this to repair damaged iron weapons/armor/tools. This ability requires iron ingots in your inventory to work.";
    }

    public String getInstructions() {
        return "Sneak with the item you want to repair in your main hand.";
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.QuickWeld.Enabled");
    }
}

