/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ProjectKorra;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.LavaAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import java.util.List;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MagmaSlap
extends LavaAbility
implements AddonAbility {
    @Attribute(value="Offset")
    private double offset;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Length")
    private int maxLength;
    @Attribute(value="Width")
    private int width;
    @Attribute(value="RevertTime")
    private long revertTime;
    private int length;
    private long next;
    private long last;
    private Location start;
    private Location curr;
    private List<TempBlock> tempBlocks;

    public MagmaSlap(Player player) {
        super(player);
        if (!this.bPlayer.canBend((CoreAbility)this)) {
            return;
        }
        if (MagmaSlap.hasAbility((Player)player, MagmaSlap.class)) {
            return;
        }
        this.setFields();
        this.start();
    }

    private void setFields() {
        this.offset = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.MagmaSlap.Offset");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.MagmaSlap.Damage");
        this.length = 0;
        this.maxLength = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.MagmaSlap.Length");
        this.width = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.MagmaSlap.Width");
        this.next = 50L;
        this.last = 0L;
        this.revertTime = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.MagmaSlap.RevertTime");
        this.start = this.player.getLocation().clone().subtract(0.0, 1.0, 0.0);
        this.start.setPitch(0.0f);
        this.start.add(this.start.getDirection().clone().multiply(this.offset));
        this.curr = this.start.clone();
        this.tempBlocks = new ArrayList<TempBlock>();
    }

    public long getCooldown() {
        return ProjectAddons.instance.getConfig().getLong("Abilities.Earth.MagmaSlap.Cooldown");
    }

    public Location getLocation() {
        return null;
    }

    public String getName() {
        return "MagmaSlap";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.length > this.maxLength) {
            this.bPlayer.addCooldown((Ability)this);
            this.remove();
            return;
        }
        if (System.currentTimeMillis() < this.last + this.next) {
            return;
        }
        this.last = System.currentTimeMillis();
        ++this.length;
        if (this.length % 4 == 0) {
            ++this.width;
        }
        for (double i = (double)(-this.width); i <= (double)this.width; i += 0.5) {
            Location check = this.curr.clone();
            if (i != 0.0) {
                Vector dir = GeneralMethods.getOrthogonalVector((Vector)check.getDirection(), (double)90.0, (double)i);
                check.add(dir);
            }
            this.checkBlock(check.getBlock());
        }
        this.curr.add(this.start.getDirection().normalize());
    }

    private void checkBlock(Block b) {
        if (TempBlock.isTempBlock((Block)b)) {
            return;
        }
        if ((b = GeneralMethods.getTopBlock((Location)b.getLocation(), (int)2)).isPassable() && !b.isLiquid()) {
            b.breakNaturally();
            b = b.getRelative(BlockFace.DOWN);
        }
        if (!MagmaSlap.isEarthbendable((Material)b.getType(), (boolean)true, (boolean)true, (boolean)true)) {
            return;
        }
        this.tempBlocks.add(new TempBlock(b, Material.AIR));
        FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)b.getLocation().add(0.5, 0.7, 0.5), (Material)Material.MAGMA_BLOCK);
        fb.setVelocity(new Vector(0.0, Math.random() * 0.3, 0.0));
        fb.setDropItem(false);
        fb.setMetadata("magmaslap", (MetadataValue)new FixedMetadataValue((Plugin)ProjectKorra.plugin, (Object)this));
        for (Entity entity : GeneralMethods.getEntitiesAroundPoint((Location)fb.getLocation(), (double)2.0)) {
            if (!(entity instanceof LivingEntity) || entity.getEntityId() == this.player.getEntityId()) continue;
            DamageHandler.damageEntity((Entity)entity, (double)this.damage, (Ability)this);
            entity.setVelocity(fb.getVelocity().multiply(2.5));
        }
        this.player.getWorld().playSound(fb.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 0.4f, 1.0f);
    }

    public void turnToTempBlock(Block b) {
        TempBlock tb;
        if (TempBlock.isTempBlock((Block)b) && this.tempBlocks.contains(tb = TempBlock.get((Block)b))) {
            tb.setType(Material.MAGMA_BLOCK);
            tb.setRevertTime(this.revertTime);
        }
    }

    public static boolean isBlock(FallingBlock fb) {
        return fb.hasMetadata("magmaslap");
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getDescription() {
        return "A simple ability in a lavabender's arsenal, this allows them to create a small wave style attack of lava that throws enemies up into the air, leaving magma in it's trail.";
    }

    public String getInstructions() {
        return "Click on your magmaslap bind";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.MagmaSlap.Enabled");
    }
}

