/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.LavaAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LavaSurge
extends LavaAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Burn")
    private boolean burn;
    @Attribute(value="BurnDuration")
    private long burnTime;
    @Attribute(value="Speed")
    private double speed;
    @Attribute(value="SourceRadius")
    private double sourceRadius;
    @Attribute(value="SelectRange")
    private int selectRange;
    @Attribute(value="Blocks")
    private int maxBlocks;
    private int shotBlocks;
    private Location sourceCenter;
    private Set<Block> source;
    private boolean shot;
    private boolean launchedAll;
    private Vector direction;
    private Set<FallingBlock> blocks;
    private Map<FallingBlock, Long> timeLived;

    public LavaSurge(Player player) {
        super(player);
        if (LavaSurge.hasAbility((Player)player, LavaSurge.class)) {
            LavaSurge abil = (LavaSurge)LavaSurge.getAbility((Player)player, LavaSurge.class);
            if (!abil.hasShot()) {
                abil.retargetSource();
            }
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.LavaSurge.Cooldown");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.LavaSurge.Damage");
        this.burn = ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.LavaSurge.Burn.Enabled");
        this.burnTime = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.LavaSurge.Burn.Duration");
        this.speed = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.LavaSurge.Speed");
        this.sourceRadius = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.LavaSurge.SourceRadius");
        this.selectRange = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.LavaSurge.SelectRange");
        this.maxBlocks = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.LavaSurge.MaxBlocks");
        this.shot = false;
        this.shotBlocks = 0;
        this.launchedAll = false;
        this.blocks = new HashSet<FallingBlock>();
        this.timeLived = new HashMap<FallingBlock, Long>();
        if (this.prepare()) {
            this.start();
        }
    }

    private boolean prepare() {
        Block b = this.player.getTargetBlock((Set)LavaSurge.getTransparentMaterialSet(), this.selectRange);
        this.sourceCenter = b.getLocation().clone().add(0.5, 0.5, 0.5);
        HashSet total = new HashSet();
        int count = 0;
        for (double i = 1.0; i <= this.sourceRadius && count < this.maxBlocks; i += 0.5) {
            List list = GeneralMethods.getBlocksAroundPoint((Location)this.sourceCenter, (double)i);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Block b2 = (Block)iter.next();
                if (total.contains(b2)) {
                    iter.remove();
                    continue;
                }
                if (!LavaSurge.isEarthbendable((Material)b2.getType(), (boolean)this.bPlayer.canMetalbend(), (boolean)true, (boolean)true)) {
                    iter.remove();
                    continue;
                }
                if (count >= this.maxBlocks) {
                    iter.remove();
                    continue;
                }
                ++count;
            }
            for (Block b2 : list) {
                if (!this.isEarthbendable(b2)) continue;
                new TempBlock(b2, Material.LAVA);
            }
            total.addAll(list);
        }
        if (total.isEmpty()) {
            return false;
        }
        this.source = new HashSet<Block>(total);
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.shot) {
            if (!this.launchedAll && this.shotBlocks < this.maxBlocks) {
                FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)this.sourceCenter.clone().add(0.0, 0.7, 0.0), (Material)Material.MAGMA_BLOCK);
                Vector v = this.direction.clone().add(new Vector(this.randomOffset(), 0.07, this.randomOffset())).normalize().multiply(this.speed);
                fb.setMetadata("lavasurge", (MetadataValue)new FixedMetadataValue((Plugin)ProjectAddons.instance, (Object)this));
                fb.setVelocity(v);
                fb.setDropItem(false);
                this.blocks.add(fb);
                this.timeLived.put(fb, System.currentTimeMillis());
                ++this.shotBlocks;
            }
            if (this.shotBlocks >= this.maxBlocks) {
                this.launchedAll = true;
            }
            Iterator<FallingBlock> iter = this.blocks.iterator();
            while (iter.hasNext()) {
                FallingBlock fb = iter.next();
                if (fb.isDead()) {
                    iter.remove();
                    continue;
                }
                if (this.timeLived.containsKey(fb) && this.timeLived.get(fb) + 4000L <= System.currentTimeMillis()) {
                    iter.remove();
                    fb.remove();
                    continue;
                }
                for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)fb.getLocation(), (double)0.7)) {
                    if (!(e instanceof LivingEntity)) continue;
                    DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
                    ((LivingEntity)e).setNoDamageTicks(0);
                    if (this.burn) {
                        ((LivingEntity)e).setFireTicks((int)(this.burnTime / 1000L * 20L));
                    }
                    iter.remove();
                    fb.remove();
                    this.timeLived.remove(fb);
                }
            }
            if (this.blocks.isEmpty()) {
                this.remove();
                return;
            }
        }
    }

    public void remove() {
        super.remove();
        for (Block b : this.source) {
            TempBlock tb = null;
            if (TempBlock.isTempBlock((Block)b)) {
                tb = TempBlock.get((Block)b);
                tb.setType(Material.AIR);
            } else {
                tb = new TempBlock(b, Material.AIR);
            }
            tb.setRevertTime(3000L);
        }
        this.bPlayer.addCooldown((Ability)this);
        this.source.clear();
        this.blocks.clear();
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "LavaSurge";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void retargetSource() {
        for (Block b : this.source) {
            if (!TempBlock.isTempBlock((Block)b)) continue;
            TempBlock.get((Block)b).revertBlock();
        }
        this.source.clear();
        if (!this.prepare()) {
            this.remove();
        }
    }

    public void shoot() {
        if (this.shot) {
            return;
        }
        this.direction = this.player.getEyeLocation().getDirection().clone();
        LavaSurge.playLavabendingSound((Location)this.sourceCenter);
        this.shot = true;
    }

    public boolean hasShot() {
        return this.shot;
    }

    public void removeBlock(FallingBlock fb) {
        this.blocks.remove(fb);
        fb.remove();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.LavaSurge.Enabled");
    }

    public String getDescription() {
        return "Throw a surging wave of lava in the direction you are looking!";
    }

    public String getInstructions() {
        return "Sneak to create your lava source (or select an existing source) and click to throw the wave!";
    }

    private double randomOffset() {
        return (Math.random() - 0.5) / 4.0;
    }
}

