/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.util.BlockSource;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Geoblast
extends EarthAbility
implements AddonAbility {
    private Location loc;
    private TempBlock source;
    private Material type;
    private long cooldown;
    private double damage;
    private int range;
    private boolean thrown;
    private boolean setup;
    private Vector direction;
    private Location target;
    private Location first;

    public Geoblast(Player player) {
        super(player);
        Geoblast blast = (Geoblast)Geoblast.getAbility((Player)player, Geoblast.class);
        if (blast != null) {
            blast.refocus();
            return;
        }
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        if (this.setFields()) {
            this.start();
        }
    }

    private boolean setFields() {
        Block b = BlockSource.getEarthSourceBlock((Player)this.player, (double)7.0, (ClickType)ClickType.SHIFT_DOWN);
        if (b == null) {
            return false;
        }
        this.type = this.getAnimationType(b.getType());
        this.source = new TempBlock(b, this.getSourceBlockType());
        this.loc = b.getLocation().add(0.5, 0.5, 0.5);
        this.setup = true;
        this.cooldown = 1000L;
        this.damage = 2.0;
        this.range = 30;
        this.thrown = false;
        return true;
    }

    private Material getAnimationType(Material type) {
        switch (type) {
            case FARMLAND: 
            case MYCELIUM: 
            case DIRT: 
            case COARSE_DIRT: 
            case GRASS_BLOCK: {
                return Material.COARSE_DIRT;
            }
            case STONE: 
            case COBBLESTONE: 
            case IRON_ORE: 
            case COAL_ORE: 
            case GRAVEL: 
            case ANDESITE: 
            case GRANITE: 
            case DIORITE: 
            case GOLD_ORE: {
                return Material.COBBLESTONE;
            }
            case SAND: 
            case SANDSTONE: {
                return Material.SANDSTONE;
            }
            case RED_SAND: 
            case RED_SANDSTONE: {
                return Material.RED_SANDSTONE;
            }
        }
        return type;
    }

    private Material getSourceBlockType() {
        return this.type == Material.OBSIDIAN ? Material.COBBLESTONE : Material.OBSIDIAN;
    }

    public void refocus() {
        if (this.thrown) {
            return;
        }
        Block b = BlockSource.getEarthSourceBlock((Player)this.player, (double)7.0, (ClickType)ClickType.SHIFT_DOWN);
        if (b == null) {
            return;
        }
        this.source.revertBlock();
        this.type = b.getType();
        this.loc = b.getLocation().add(0.5, 0.5, 0.5);
        this.source = new TempBlock(b, this.getSourceBlockType());
    }

    public void launch() {
        if (!this.thrown) {
            this.thrown = true;
            this.source.setType(Material.AIR);
            this.bPlayer.addCooldown((Ability)this);
        }
        this.locateTarget();
    }

    private void pathing() {
        if (this.loc.getBlockY() == this.first.getBlockY()) {
            this.setup = false;
        }
        this.direction = this.setup ? GeneralMethods.getDirection((Location)this.loc, (Location)this.first).normalize() : GeneralMethods.getDirection((Location)this.loc, (Location)this.target).normalize();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.thrown) {
            if (this.loc.distance(this.player.getEyeLocation()) > (double)this.range) {
                this.remove();
                return;
            }
            this.pathing();
            if (this.loc.getBlock().isLiquid() && this.direction.length() != 0.8) {
                this.direction.multiply(0.8);
            }
            this.loc.add(this.direction);
            if (!this.loc.getBlock().isPassable()) {
                this.remove();
                return;
            }
            if (GeneralMethods.isTransparent((Block)this.loc.getBlock()) && !this.loc.getBlock().isLiquid()) {
                GeneralMethods.breakBlock((Block)this.loc.getBlock());
            }
            new TempBlock(this.loc.getBlock(), this.type).setRevertTime(60L);
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.loc, (double)1.0)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
                this.remove();
                return;
            }
        } else {
            if (!this.source.getLocation().getWorld().equals(this.player.getLocation().getWorld())) {
                this.remove();
                return;
            }
            if (this.source.getLocation().distance(this.player.getLocation()) > (double)this.range) {
                this.remove();
                return;
            }
        }
    }

    public void remove() {
        super.remove();
        this.source.setRevertTime(10000L);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Geoblast";
    }

    public Location getLocation() {
        return this.loc;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return false;
    }

    private void locateTarget() {
        int j;
        Entity target = GeneralMethods.getTargetedEntity((Player)this.player, (double)this.range, new ArrayList());
        Material[] trans = new Material[Geoblast.getTransparentMaterials().length + this.getEarthbendableBlocks().size()];
        int i = 0;
        for (j = 0; j < Geoblast.getTransparentMaterials().length; ++j) {
            trans[j] = Geoblast.getTransparentMaterials()[j];
            ++i;
        }
        for (j = 0; j < this.getEarthbendableBlocks().size(); ++j) {
            try {
                trans[i] = Material.valueOf((String)((String)this.getEarthbendableBlocks().get(j)));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            ++i;
        }
        this.target = target == null ? GeneralMethods.getTargetedLocation((Player)this.player, (double)this.range, (boolean)true, (Material[])trans) : ((LivingEntity)target).getEyeLocation();
        this.first = this.loc.clone();
        if (this.target.getY() - this.loc.getY() > 2.0) {
            this.first.setY(this.target.getY() - 1.0);
        } else if (this.loc.getY() > this.player.getEyeLocation().getY() && this.loc.getBlock().getRelative(BlockFace.UP).isPassable()) {
            this.first.subtract(0.0, 2.0, 0.0);
        } else if (this.loc.getBlock().getRelative(BlockFace.UP).isPassable() && this.loc.getBlock().getRelative(BlockFace.UP, 2).isPassable()) {
            this.first.add(0.0, 2.0, 0.0);
        } else {
            this.first.add(GeneralMethods.getDirection((Location)this.loc, (Location)this.target).normalize().setY(0));
        }
    }
}

