/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.util.Vector;

public class EarthKick
extends EarthAbility
implements AddonAbility,
Listener {
    private static Set<FallingBlock> BLOCKS = new HashSet<FallingBlock>();
    @Attribute(value="Damage")
    public double damage;
    @Attribute(value="Blocks")
    public int maxBlocks;
    @Attribute(value="LavaMultiplier")
    public double lavaMult;
    public List<FallingBlock> kick;
    public long duration = 2500L;

    public EarthKick(Player player) {
        super(player);
        if (EarthKick.getAbility(((Object)((Object)this)).getClass()) == null) {
            return;
        }
        this.setFields();
        if (this.launchKick()) {
            this.bPlayer.addCooldown((Ability)this);
            this.start();
        }
    }

    public void setFields() {
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.EarthKick.Damage");
        this.maxBlocks = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.EarthKick.MaxBlocks");
        this.lavaMult = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.EarthKick.LavaMultiplier");
        this.kick = new ArrayList<FallingBlock>();
    }

    public Element getElement() {
        return Element.EARTH;
    }

    public Location getLocation() {
        return null;
    }

    public List<Location> getLocations() {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (FallingBlock fb : this.kick) {
            locs.add(fb.getLocation());
        }
        return locs;
    }

    public String getName() {
        return "EarthKick";
    }

    public boolean isExplosiveAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isIgniteAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        ArrayList<FallingBlock> removal = new ArrayList<FallingBlock>();
        for (FallingBlock fb : this.kick) {
            if (!BLOCKS.contains(fb)) {
                removal.add(fb);
                continue;
            }
            if (fb == null || fb.isDead()) {
                removal.add(fb);
                continue;
            }
            ParticleEffect.BLOCK_CRACK.display(fb.getLocation(), 3, 0.1, 0.1, 0.1, (Object)fb.getBlockData());
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)fb.getLocation(), (double)1.5)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                ((LivingEntity)e).setNoDamageTicks(0);
                if (removal.contains(fb)) continue;
                removal.add(fb);
            }
        }
        for (FallingBlock fb : removal) {
            this.kick.remove(fb);
            if (BLOCKS.contains(fb)) {
                BLOCKS.remove(fb);
            }
            fb.remove();
        }
        if (this.kick.isEmpty()) {
            this.remove();
            return;
        }
        if (System.currentTimeMillis() > this.getStartTime() + this.duration) {
            this.remove();
            return;
        }
    }

    public boolean launchKick() {
        Block b = this.player.getTargetBlock((Set)EarthKick.getTransparentMaterialSet(), 3);
        Material type = b.getType();
        if (TempBlock.isTempBlock((Block)b)) {
            return false;
        }
        if (!EarthAbility.isEarthbendable((Material)type, (boolean)this.bPlayer.canMetalbend(), (boolean)this.bPlayer.canSandbend(), (boolean)this.bPlayer.canLavabend())) {
            return false;
        }
        if (type == Material.LAVA) {
            if (this.bPlayer.canLavabend()) {
                type = Material.MAGMA_BLOCK;
                this.damage *= this.lavaMult;
            } else {
                return false;
            }
        }
        for (int i = 0; i < this.maxBlocks; ++i) {
            FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)b.getLocation().clone().add(0.5, 1.2, 0.5), (Material)type);
            fb.setDropItem(false);
            Location loc = this.player.getLocation().clone();
            loc.setPitch(0.0f);
            loc.setYaw(loc.getYaw() + (float)new Random().nextInt(25) - 12.0f);
            Vector vec = loc.getDirection();
            vec.setY(Math.max(0.3, Math.random() / 2.0));
            vec.setX(vec.getX() / 1.2);
            vec.setZ(vec.getZ() / 1.2);
            fb.setVelocity(vec);
            this.kick.add(fb);
            BLOCKS.add(fb);
        }
        EarthKick.playEarthbendingSound((Location)this.player.getLocation());
        return true;
    }

    public void remove() {
        super.remove();
        for (FallingBlock fb : this.kick) {
            fb.remove();
            if (!BLOCKS.contains(fb)) continue;
            BLOCKS.remove(fb);
        }
    }

    public long getCooldown() {
        return ProjectAddons.instance.getConfig().getLong("Abilities.Earth.EarthKick.Cooldown");
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getDescription() {
        return "Earthbenders can kick the earth in front of them and send shards flying towards their enemies.";
    }

    public String getInstructions() {
        return "Sneak at earth in front of you";
    }

    public static boolean isBlock(FallingBlock fb) {
        return BLOCKS.contains(fb);
    }

    public static void removeBlock(FallingBlock fb) {
        if (EarthKick.isBlock(fb)) {
            BLOCKS.remove(fb);
            fb.remove();
        }
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.EarthKick.Enabled");
    }
}

