/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ParticleEffect;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Dig
extends EarthAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="RevertTime")
    private long revertTime;
    @Attribute(value="Speed")
    private double speed;

    public Dig(Player player) {
        super(player);
        if (!this.isEarthbendable(player.getLocation().getBlock().getRelative(BlockFace.DOWN))) {
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Dig.Cooldown");
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Dig.Duration");
        this.revertTime = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Dig.RevertTime");
        this.speed = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.Dig.Speed");
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead() || !this.player.isSneaking()) {
            this.remove();
            return;
        }
        if (this.duration > 0L && System.currentTimeMillis() > this.getStartTime() + this.duration) {
            this.remove();
            return;
        }
        Block b = this.player.getTargetBlock((Set)Dig.getTransparentMaterialSet(), 4);
        if (!this.isEarthbendable(b)) {
            this.player.setVelocity(this.player.getEyeLocation().getDirection().clone().normalize().multiply(0.9));
            this.remove();
            return;
        }
        for (Block block : GeneralMethods.getBlocksAroundPoint((Location)this.player.getEyeLocation(), (double)2.4)) {
            if (!this.isEarthbendable(block)) continue;
            ParticleEffect.BLOCK_CRACK.display(block.getLocation().add(0.5, 0.5, 0.5), 5, 0.25, 0.25, 0.25, (Object)block.getBlockData());
            new TempBlock(block, Material.AIR).setRevertTime(this.revertTime);
        }
        ParticleEffect.CRIT.display(this.player.getEyeLocation(), 7, 0.6, 0.6, 0.6);
        this.player.setGliding(true);
        this.player.setVelocity(this.player.getEyeLocation().getDirection().clone().normalize().multiply(this.speed));
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 5, 1), true);
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Dig";
    }

    public Location getLocation() {
        return this.player.getEyeLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.Dig.Enabled");
    }

    public String getDescription() {
        return "Swim through the earth, digging a path with your earthbending. Inspired by toph's learning from the badgermoles! You must also be looking at an earthbendable block for the ability to work!";
    }

    public String getInstructions() {
        return "Sneak while on an earthbendable block";
    }
}

