/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ProjectKorra;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.SandAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.HashMap;
import java.util.Map;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Crumble
extends SandAbility
implements AddonAbility {
    @Attribute(value="Radius")
    private int maxRadius;
    @Attribute(value="RevertTime")
    private int revertTime;
    @Attribute(value="Cooldown")
    private long cooldown;
    private int radius;
    private int counter;
    private Block center;
    private Map<Block, BlockData> revert;

    public Crumble(Player player, ClickType click) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        if (click == ClickType.LEFT_CLICK) {
            int selectRange = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.Crumble.SelectRange");
            this.center = player.getTargetBlock(null, selectRange);
        } else {
            this.center = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
        }
        this.revert = new HashMap<Block, BlockData>();
        this.revertTime = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.Crumble.RevertTime");
        this.counter = 0;
        this.radius = 0;
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Crumble.Cooldown");
        this.maxRadius = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.Crumble.Radius");
        this.start();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return null;
    }

    public String getName() {
        return "Crumble";
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.radius > this.maxRadius) {
            this.remove();
            return;
        }
        ++this.counter;
        if (this.counter % 2 != 0) {
            return;
        }
        int theta = 0;
        while (theta < 360) {
            double x = Math.cos(Math.toRadians(theta)) * (double)this.radius;
            double z = Math.sin(Math.toRadians(theta)) * (double)this.radius;
            Block block = this.center.getRelative((int)x, 0, (int)z);
            block = GeneralMethods.getTopBlock((Location)block.getLocation(), (int)2);
            int i = 0;
            while (block.isPassable() && i < 2) {
                if (Crumble.isPlant((Block)block)) {
                    new TempBlock(block, Material.AIR).setRevertTime((long)this.revertTime);
                }
                block = block.getRelative(BlockFace.DOWN);
                ++i;
            }
            if (!TempBlock.isTempBlock((Block)block) && this.isEarthbendable(block) && !Crumble.isSand((Block)block)) {
                Material m = Material.SAND;
                if (Crumble.isAir((Material)block.getRelative(BlockFace.DOWN).getType())) {
                    m = Material.SANDSTONE;
                }
                this.revert.put(block, block.getBlockData());
                final Block b = block;
                new BukkitRunnable(){

                    public void run() {
                        b.setBlockData((BlockData)Crumble.this.revert.get(b));
                    }
                }.runTaskLater((Plugin)ProjectKorra.plugin, (long)(20 * this.revertTime));
                block.setType(m);
            }
            theta += 5;
        }
        ++this.radius;
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public void revert() {
        for (Block b : this.revert.keySet()) {
            b.setBlockData(this.revert.get(b));
        }
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.Crumble.Enabled");
    }

    public String getDescription() {
        return "Crumble the earth into sand!";
    }

    public String getInstructions() {
        return "Left click or sneak";
    }
}

