/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.earthbending.Collapse;
import com.projectkorra.projectkorra.earthbending.RaiseEarth;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Bulwark
extends EarthAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    private Set<Location> locs;
    private Set<Block> blocks;
    private Set<FallingBlock> fbs;
    private Set<RaiseEarth> parts;
    private Location start;
    private boolean launched;
    private long launchTime;

    public Bulwark(Player player) {
        super(player);
        Vector v;
        double i;
        if (!player.isOnGround()) {
            return;
        }
        this.start = player.getLocation().subtract(0.0, 1.0, 0.0);
        if (!this.isEarthbendable(this.start.getBlock())) {
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Bulwark.Cooldown");
        this.locs = new HashSet<Location>();
        this.blocks = new HashSet<Block>();
        this.fbs = new HashSet<FallingBlock>();
        this.parts = new HashSet<RaiseEarth>();
        this.launchTime = 0L;
        this.launched = false;
        Location front = this.start.clone().add(player.getLocation().getDirection().setY(0).normalize().multiply(2.5));
        Location left = GeneralMethods.getLeftSide((Location)this.start, (double)3.0);
        Location right = GeneralMethods.getRightSide((Location)this.start, (double)3.0);
        Vector toLeft = GeneralMethods.getDirection((Location)front, (Location)left);
        Vector toRight = GeneralMethods.getDirection((Location)front, (Location)right);
        this.parts.add(new RaiseEarth(player, front, 3));
        this.locs.add(front.clone());
        double leftLength = toLeft.length() + 1.0;
        double rightLength = toRight.length() + 1.0;
        for (i = 0.5; i <= leftLength; i += 0.5) {
            v = toLeft.normalize().multiply(i);
            front.add(v);
            this.parts.add(new RaiseEarth(player, front, Math.min(2, (int)(leftLength - i))));
            this.locs.add(front.clone());
            front.subtract(v);
        }
        for (i = 0.5; i <= rightLength; i += 0.5) {
            v = toRight.normalize().multiply(i);
            front.add(v);
            this.parts.add(new RaiseEarth(player, front, Math.min(2, (int)(rightLength - i))));
            this.locs.add(front.clone());
            front.subtract(v);
        }
        this.start();
    }

    public void progress() {
        if (!this.launched) {
            if (this.start.distance(this.player.getLocation().subtract(0.0, 1.0, 0.0)) > 1.5) {
                this.remove();
                return;
            }
            if (!this.player.isSneaking()) {
                this.remove();
                return;
            }
            for (RaiseEarth re : this.parts) {
                this.blocks.addAll(re.getAffectedBlocks().values());
            }
        } else {
            if (this.launchTime + 3000L <= System.currentTimeMillis()) {
                this.remove();
                return;
            }
            ArrayList<FallingBlock> removal = new ArrayList<FallingBlock>();
            block1: for (FallingBlock fb : this.fbs) {
                if (fb.isDead()) {
                    removal.add(fb);
                    break;
                }
                for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)fb.getLocation(), (double)0.8)) {
                    if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                    DamageHandler.damageEntity((Entity)e, (double)1.0, (Ability)this);
                    removal.add(fb);
                    fb.remove();
                    continue block1;
                }
            }
            for (FallingBlock fb : removal) {
                this.fbs.remove(fb);
            }
            if (this.fbs.isEmpty()) {
                this.remove();
            }
        }
    }

    public void remove() {
        super.remove();
        for (Location loc : this.locs) {
            if (Bulwark.isAir((Material)loc.getBlock().getType())) {
                loc.add(0.0, 1.0, 0.0);
            }
            new Collapse(this.player, loc);
        }
        for (FallingBlock fb : this.fbs) {
            fb.remove();
        }
        this.fbs.clear();
        this.locs.clear();
        this.blocks.clear();
        this.bPlayer.addCooldown((Ability)this);
    }

    public void clickFunction() {
        if (this.launched) {
            return;
        }
        this.launched = true;
        for (Block b : this.blocks) {
            BlockData data = b.getBlockData();
            b.setType(Material.AIR);
            FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)b.getLocation().add(0.5, 0.5, 0.5), (Material)data.getMaterial(), (BlockData)data);
            fb.setDropItem(false);
            fb.setMetadata("bulwark", (MetadataValue)new FixedMetadataValue((Plugin)ProjectAddons.instance, (Object)this));
            fb.setVelocity(this.player.getEyeLocation().getDirection().setY(0.195).normalize().multiply(0.9));
            this.fbs.add(fb);
        }
        this.launchTime = System.currentTimeMillis();
        this.locs.clear();
        this.blocks.clear();
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Bulwark";
    }

    public Location getLocation() {
        return this.start;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Raise a shield of earth in front of you, and it lowers when you release sneak!";
    }

    public String getInstructions() {
        return "Hold Sneak";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.Bulwark.Enabled");
    }
}

