/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.earth;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.EarthAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import com.projectkorra.projectkorra.util.TempBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Accretion
extends EarthAbility
implements AddonAbility {
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Blocks")
    private int blocks;
    @Attribute(value="SelectRange")
    private int selectRange;
    @Attribute(value="RevertTime")
    private long revertTime;
    @Attribute(value="Cooldown")
    private long cooldown;
    private Set<FallingBlock> tracker;
    private Set<TempBlock> temps;
    private boolean shot;

    public Accretion(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        if (!this.isEarthbendable(player.getLocation().getBlock().getRelative(BlockFace.DOWN))) {
            return;
        }
        if (Accretion.hasAbility((Player)player, Accretion.class)) {
            return;
        }
        if (GeneralMethods.isRegionProtectedFromBuild((Ability)this, (Location)player.getLocation())) {
            return;
        }
        this.shot = false;
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Earth.Accretion.Damage");
        this.blocks = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.Accretion.Blocks");
        this.selectRange = ProjectAddons.instance.getConfig().getInt("Abilities.Earth.Accretion.SelectRange");
        this.revertTime = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Accretion.RevertTime");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Earth.Accretion.Cooldown");
        this.tracker = new HashSet<FallingBlock>();
        this.temps = new HashSet<TempBlock>();
        List list = GeneralMethods.getCircle((Location)player.getLocation(), (int)this.selectRange, (int)1, (boolean)false, (boolean)false, (int)0);
        for (int i = 0; i < list.size(); ++i) {
            Block b = GeneralMethods.getTopBlock((Location)((Location)list.get(new Random().nextInt(list.size()))), (int)2);
            if (!Accretion.isAir((Material)b.getRelative(BlockFace.UP).getType()) || TempBlock.isTempBlock((Block)b) || !Accretion.isEarthbendable((Material)b.getType(), (boolean)true, (boolean)true, (boolean)false)) continue;
            Material type = b.getType();
            this.temps.add(new TempBlock(b, Material.AIR));
            FallingBlock fb = GeneralMethods.spawnFallingBlock((Location)b.getLocation().add(0.5, 0.5, 0.5), (Material)type);
            fb.setVelocity(new Vector(0.0, 0.8, 0.0));
            fb.setMetadata("accretion", (MetadataValue)new FixedMetadataValue((Plugin)ProjectAddons.instance, (Object)this));
            fb.setHurtEntities(false);
            fb.setDropItem(false);
            this.tracker.add(fb);
            if (this.temps.size() == this.blocks) break;
        }
        Accretion.playEarthbendingSound((Location)player.getLocation());
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        ArrayList<FallingBlock> remove = new ArrayList<FallingBlock>();
        block0: for (FallingBlock fb : this.tracker) {
            ParticleEffect.BLOCK_CRACK.display(fb.getLocation(), 2, 0.1, 0.1, 0.1, (Object)fb.getBlockData());
            if (!this.shot) continue;
            for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)fb.getLocation(), (double)1.0)) {
                if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                this.entityCollision(fb, (LivingEntity)e);
                remove.add(fb);
                continue block0;
            }
        }
        this.tracker.removeAll(remove);
        if (this.tracker.isEmpty()) {
            this.remove();
            return;
        }
        if (System.currentTimeMillis() - this.getStartTime() >= 6000L) {
            for (FallingBlock fb : this.tracker) {
                fb.remove();
            }
            this.remove();
            return;
        }
    }

    public void remove() {
        super.remove();
        this.tracker.clear();
        for (TempBlock tb : this.temps) {
            if (tb.getBlockData().getMaterial() != Material.AIR) continue;
            tb.revertBlock();
        }
        this.temps.clear();
    }

    public void entityCollision(FallingBlock fb, LivingEntity entity) {
        int duration = 20;
        int amp = 1;
        if (entity.hasPotionEffect(PotionEffectType.SLOW)) {
            PotionEffect effect = entity.getPotionEffect(PotionEffectType.SLOW);
            duration += effect.getDuration();
            amp += effect.getAmplifier();
            entity.removePotionEffect(PotionEffectType.SLOW);
        }
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, duration, amp, true, false));
        DamageHandler.damageEntity((Entity)entity, (double)this.damage, (Ability)this);
        fb.remove();
    }

    public void blockCollision(FallingBlock fb, Block block) {
        TempBlock tb;
        if (TempBlock.isTempBlock((Block)block)) {
            tb = TempBlock.get((Block)block);
            tb.setType(fb.getBlockData());
        } else {
            tb = new TempBlock(block, fb.getBlockData().getMaterial());
        }
        tb.setRevertTime(this.revertTime);
        this.temps.add(tb);
        this.tracker.remove(fb);
        fb.remove();
    }

    public void shoot() {
        if (this.shot) {
            return;
        }
        if (this.tracker.isEmpty()) {
            this.remove();
            return;
        }
        Accretion.playEarthbendingSound((Location)this.player.getLocation());
        for (FallingBlock fb : this.tracker) {
            Location target = null;
            Entity e = GeneralMethods.getTargetedEntity((Player)this.player, (double)30.0);
            target = e != null ? e.getLocation() : GeneralMethods.getTargetedLocation((Player)this.player, (int)30);
            fb.setVelocity(GeneralMethods.getDirection((Location)fb.getLocation(), (Location)target).normalize().multiply(1.5));
        }
        this.bPlayer.addCooldown((Ability)this);
        this.shot = true;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Accretion";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Earth.Accretion.Enabled");
    }

    public String getDescription() {
        return "Slam the earth to send blocks into the air, then shoot them all towards a single point! They will build up on an enemy, damaging and slowing them down! Each block that hits adds 1 second and level of slowness.";
    }

    public String getInstructions() {
        return "Sneak to rise blocks, Left Click before they land to shoot!";
    }
}

