/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.chi;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ChiAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class WeakeningJab
extends ChiAbility
implements ComboAbility,
AddonAbility {
    private static Set<Integer> entities = new HashSet<Integer>();
    @Attribute(value="Duration")
    public long duration;
    @Attribute(value="Cooldown")
    public long cooldown;
    public LivingEntity entity = null;

    public WeakeningJab(Player player) {
        super(player);
        Entity e = GeneralMethods.getTargetedEntity((Player)player, (double)4.0);
        if (!(e instanceof LivingEntity)) {
            return;
        }
        this.entity = (LivingEntity)e;
        this.duration = ProjectAddons.instance.getConfig().getLong("Combos.Chi.WeakeningJab.Duration");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Chi.WeakeningJab.Cooldown");
        if (this.entity != null && !entities.contains(this.entity.getEntityId())) {
            entities.add(this.entity.getEntityId());
            this.start();
        }
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.entity.getLocation().clone().add(0.0, 1.0, 0.0);
    }

    public String getName() {
        return "WeakeningJab";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        ParticleEffect.DAMAGE_INDICATOR.display(this.entity.getLocation(), 3, 0.2, 1.0, 0.2, 4.0E-4);
        if (System.currentTimeMillis() >= this.getStartTime() + this.duration) {
            entities.remove(this.entity.getEntityId());
            this.remove();
            this.bPlayer.addCooldown((Ability)this);
        }
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public Object createNewComboInstance(Player player) {
        return new WeakeningJab(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.LEFT_CLICK_ENTITY));
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.LEFT_CLICK_ENTITY));
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.RIGHT_CLICK_ENTITY));
        return combo;
    }

    public String getDescription() {
        return "This special jab damages the enemy's defenses, making them more susceptible to damage!";
    }

    public String getInstructions() {
        return "Jab (Left) > Jab (Left) > Jab (Right)";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Chi.WeakeningJab.Enabled");
    }

    public static boolean isAffected(Entity e) {
        return entities.contains(e.getEntityId());
    }

    public static double getModifier() {
        return ProjectAddons.instance.getConfig().getDouble("Combos.Chi.WeakeningJab.Modifier");
    }
}

