/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.chi;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ChiAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NinjaStance
extends ChiAbility
implements AddonAbility {
    @Attribute(value="Duration")
    public long stealthDuration;
    @Attribute(value="SpeedBoost")
    public int speedAmp;
    @Attribute(value="JumpBoost")
    public int jumpAmp;
    public boolean stealth;
    public boolean stealthReady;
    public boolean stealthStarted;
    public long stealthStart;
    public long stealthChargeTime;
    public long stealthReadyStart;

    public NinjaStance(Player player) {
        super(player);
        ChiAbility stance = this.bPlayer.getStance();
        if (stance != null) {
            stance.remove();
            if (stance instanceof NinjaStance) {
                this.bPlayer.setStance(null);
                return;
            }
        }
        this.stealthDuration = ProjectAddons.instance.getConfig().getLong("Abilities.Chi.NinjaStance.Stealth.Duration");
        this.stealthChargeTime = ProjectAddons.instance.getConfig().getLong("Abilities.Chi.NinjaStance.Stealth.ChargeTime");
        this.speedAmp = ProjectAddons.instance.getConfig().getInt("Abilities.Chi.NinjaStance.SpeedAmplifier") + 1;
        this.jumpAmp = ProjectAddons.instance.getConfig().getInt("Abilities.Chi.NinjaStance.JumpAmplifier") + 1;
        this.start();
        this.bPlayer.setStance((ChiAbility)this);
        GeneralMethods.displayMovePreview((Player)player);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_HURT, 0.2f, 2.0f);
    }

    public long getCooldown() {
        return ProjectAddons.instance.getConfig().getLong("Abilities.Chi.NinjaStance.Cooldown");
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public String getName() {
        return "NinjaStance";
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.stealth) {
            if (System.currentTimeMillis() >= this.stealthStart + this.stealthChargeTime) {
                this.stealthReady = true;
            }
            if (!this.stealthStarted) {
                if (this.stealthReady && !this.player.isSneaking()) {
                    this.stealthReadyStart = System.currentTimeMillis();
                    this.stealthStarted = true;
                } else if (!this.player.isSneaking()) {
                    this.stopStealth();
                } else if (this.stealthReady && this.player.isSneaking()) {
                    Location play = this.player.getEyeLocation().clone().add(this.player.getEyeLocation().getDirection().normalize());
                    GeneralMethods.displayColoredParticle((String)"#00ee00", (Location)play);
                } else {
                    Location play = this.player.getEyeLocation().clone().add(this.player.getEyeLocation().getDirection().normalize());
                    GeneralMethods.displayColoredParticle((String)"#000000", (Location)play);
                }
            } else if (System.currentTimeMillis() >= this.stealthReadyStart + this.stealthDuration) {
                this.stopStealth();
            } else {
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 5, 2, true, false), true);
            }
        }
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 5, this.speedAmp, true, false), true);
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 5, this.jumpAmp, true, false), true);
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getDescription() {
        return "This stance allows chiblockers to become faster and more stealthy (like a ninja)!";
    }

    public String getInstructions() {
        return "Left click to begin to this stance > Hold sneak to begin stealth mode";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Chi.NinjaStance.Enabled");
    }

    public void beginStealth() {
        if (this.stealth) {
            this.player.sendMessage("Already cloaked!");
            return;
        }
        this.stealth = true;
        this.stealthStart = System.currentTimeMillis();
    }

    public void stopStealth() {
        this.stealth = false;
        this.stealthReady = false;
        this.stealthStarted = false;
    }

    public static double getDamageModifier() {
        return ProjectAddons.instance.getConfig().getDouble("Abilities.Chi.NinjaStance.DamageModifier");
    }
}

