/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.chi;

import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ChiAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.chi.WeakeningJab;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Jab
extends ChiAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Chi.Jab.Cooldown");
    @Attribute(value="MaxUses")
    private int maxUses = ProjectAddons.instance.getConfig().getInt("Abilities.Chi.Jab.MaxUses");
    private int uses = 0;

    public Jab(Player player, Entity entity, JabHand hand) {
        super(player);
        this.start();
        this.activate(entity, hand);
    }

    public void activate(Entity entity, JabHand hand) {
        if (this.bPlayer.isOnCooldown("jab interval")) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity lent = (LivingEntity)entity;
            ++this.uses;
            ParticleEffect.END_ROD.display(entity.getLocation().clone().add(0.0, 1.0, 0.0), 4, 0.2, 0.2, 0.2, 0.02);
            if (hand == JabHand.LEFT) {
                double damage = WeakeningJab.isAffected((Entity)lent) ? WeakeningJab.getModifier() : 1.0;
                DamageHandler.damageEntity((Entity)entity, (Player)this.player, (double)damage, (Ability)this);
            }
            this.bPlayer.addCooldown("jab interval", 70L);
            lent.setNoDamageTicks(0);
        }
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return null;
    }

    public String getName() {
        return "Jab";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        if (this.uses >= this.maxUses) {
            this.remove();
            this.bPlayer.addCooldown((Ability)this);
        }
    }

    public String getDescription() {
        return "A fundamental ability for any chiblocker, this ability allows for rapid attacks and can be chained for different combos!";
    }

    public String getInstructions() {
        return "Left click or Right click";
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Chi.Jab.Enabled");
    }

    public static enum JabHand {
        RIGHT,
        LEFT;

    }
}

