/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.chi;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ChiAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FlyingKick
extends ChiAbility
implements ComboAbility,
AddonAbility {
    @Attribute(value="LaunchPower")
    private double launch;
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Cooldown")
    private long cooldown;

    public FlyingKick(Player player) {
        super(player);
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        if (FlyingKick.hasAbility((Player)player, FlyingKick.class)) {
            return;
        }
        if (player.getLocation().getBlock().isLiquid()) {
            return;
        }
        if (!player.isOnGround()) {
            return;
        }
        this.launch = ProjectAddons.instance.getConfig().getDouble("Combos.Chi.FlyingKick.LaunchPower");
        this.damage = ProjectAddons.instance.getConfig().getDouble("Combos.Chi.FlyingKick.Damage");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Chi.FlyingKick.Cooldown");
        Vector v = player.getLocation().getDirection().add(new Vector(0.0, 0.25485, 0.0)).normalize().multiply(this.launch);
        player.setVelocity(v);
        this.start();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public String getName() {
        return "FlyingKick";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        if (this.player == null) {
            this.remove();
            return;
        }
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (System.currentTimeMillis() > this.getStartTime() + 400L && this.player.getLocation().subtract(0.0, 0.1, 0.0).getBlock().getType() != Material.AIR) {
            this.remove();
            this.bPlayer.addCooldown((Ability)this);
            return;
        }
        ParticleEffect.CRIT_MAGIC.display(this.player.getLocation(), 3, 0.2, 0.2, 0.2, 0.02);
        for (Entity entity : GeneralMethods.getEntitiesAroundPoint((Location)this.player.getLocation(), (double)2.0)) {
            if (!(entity instanceof LivingEntity) || entity.getEntityId() == this.player.getEntityId()) continue;
            DamageHandler.damageEntity((Entity)entity, (Player)this.player, (double)this.damage, (Ability)this);
        }
    }

    public Object createNewComboInstance(Player player) {
        return new FlyingKick(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("SwiftKick", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("SwiftKick", ClickType.LEFT_CLICK));
        return combo;
    }

    public String getDescription() {
        return "Jump through the air and kick your opponent!";
    }

    public String getInstructions() {
        return "SwiftKick (Hold sneak) > SwiftKick (Left Click)";
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Chi.FlyingKick.Enabled");
    }
}

