/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.chi;

import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.ChiAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ChiblockJab
extends ChiAbility
implements ComboAbility,
AddonAbility {
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Cooldown")
    private long cooldown;
    private Player attacked;
    private BendingPlayer bp;

    public ChiblockJab(Player player) {
        super(player);
        Entity entity = GeneralMethods.getTargetedEntity((Player)player, (double)4.0);
        if (!(entity instanceof Player)) {
            return;
        }
        this.attacked = (Player)entity;
        this.duration = ProjectAddons.instance.getConfig().getLong("Combos.Chi.ChiblockJab.Duration");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Chi.ChiblockJab.Cooldown");
        if (this.attacked != null) {
            this.bp = BendingPlayer.getBendingPlayer((Player)this.attacked);
            if (this.bp != null) {
                this.bp.blockChi();
                this.start();
            }
        }
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.attacked.getLocation().clone().add(0.0, 1.0, 0.0);
    }

    public String getName() {
        return "ChiblockJab";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return false;
    }

    public void progress() {
        ParticleEffect.CRIT.display(this.attacked.getLocation().clone().add(0.0, 1.0, 0.0), 3, 0.2, 1.0, 0.2, 0.04);
        if (System.currentTimeMillis() >= this.getStartTime() + this.duration) {
            this.remove();
            this.bPlayer.addCooldown((Ability)this);
            this.bp.unblockChi();
        }
    }

    public Object createNewComboInstance(Player player) {
        return new ChiblockJab(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.RIGHT_CLICK_ENTITY));
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.LEFT_CLICK_ENTITY));
        combo.add(new ComboManager.AbilityInformation("Jab", ClickType.RIGHT_CLICK_ENTITY));
        return combo;
    }

    public String getDescription() {
        return "A special jab that has a much higher chance of blocking the enemy's chi!";
    }

    public String getInstructions() {
        return "Jab (Right) > Jab (Left) > Jab (Right)";
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Chi.ChiblockJab.Enabled");
    }
}

