/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.avatar;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.AvatarAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.DamageHandler;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EnergyBeam
extends AvatarAbility
implements AddonAbility {
    public static Map<UUID, EnergyColor> colors = new HashMap<UUID, EnergyColor>();
    @Attribute(value="Damage")
    private double damage;
    @Attribute(value="Range")
    private int range;
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="EasterEgg")
    private boolean effects;
    private Map<Location, Vector> map;
    private Map<Location, Integer> ranges;
    private EnergyColor color;

    public EnergyBeam(Player player) {
        super(player);
        if (!this.bPlayer.canBend((CoreAbility)this)) {
            return;
        }
        this.setFields();
        this.start();
    }

    public void setFields() {
        this.map = new ConcurrentHashMap<Location, Vector>();
        this.ranges = new HashMap<Location, Integer>();
        this.damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Avatar.EnergyBeam.Damage");
        this.range = ProjectAddons.instance.getConfig().getInt("Abilities.Avatar.EnergyBeam.Range");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Avatar.EnergyBeam.Cooldown");
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Avatar.EnergyBeam.Duration");
        this.effects = ProjectAddons.instance.getConfig().getBoolean("Abilities.Avatar.EnergyBeam.EasterEgg");
        this.color = colors.containsKey(this.player.getUniqueId()) ? colors.get(this.player.getUniqueId()) : EnergyColor.BLUE;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Location getLocation() {
        return this.player.getEyeLocation().clone();
    }

    public String getName() {
        return "EnergyBeam";
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public boolean isSneakAbility() {
        return true;
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (!this.bPlayer.canBend((CoreAbility)this)) {
            this.remove();
            return;
        }
        if (this.getStartTime() + this.duration < System.currentTimeMillis()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        Vector direction = this.player.getLocation().getDirection().clone();
        Location center = this.player.getLocation().clone().add(0.0, 1.0, 0.0);
        this.map.put(center, direction);
        this.ranges.put(center, 0);
        for (Location loc : this.map.keySet()) {
            this.collide(loc);
            Vector next = this.map.get(loc);
            if (this.ranges.get(loc) == null) continue;
            int range = this.ranges.get(loc);
            if (this.ranges.get(loc) > this.range) {
                this.ranges.remove(loc);
                this.map.remove(loc);
                continue;
            }
            if (new Random().nextInt(2) == 0) {
                this.displayParticles(loc);
                if (new Random().nextInt(4) == 0) {
                    this.player.getWorld().playSound(loc, Sound.ENTITY_WITHER_AMBIENT, 0.2f, 0.7f);
                }
            }
            if (this.damageEntities(loc)) {
                this.ranges.remove(loc);
                this.map.remove(loc);
                continue;
            }
            Location nextLoc = loc.add(next);
            if (GeneralMethods.isSolid((Block)nextLoc.getBlock()) || GeneralMethods.isRegionProtectedFromBuild((Player)this.player, (Location)nextLoc)) {
                ParticleEffect.EXPLOSION_LARGE.display(nextLoc, 0, 0.0, 0.0, (double)0.01f, 1.0);
                this.map.remove(loc);
                this.ranges.remove(loc);
                continue;
            }
            this.map.remove(loc);
            this.map.put(nextLoc, next);
            this.ranges.remove(loc);
            this.ranges.put(nextLoc, range + 1);
        }
    }

    public void collide(Location loc) {
        for (EnergyBeam abil : EnergyBeam.getAbilities(EnergyBeam.class)) {
            if (abil == this) continue;
            for (Location check : abil.map.keySet()) {
                if (!(loc.distance(check) < 1.5)) continue;
                this.remove();
                abil.remove();
                Location center = new Location(loc.getWorld(), (loc.getX() + check.getX()) / 2.0, (loc.getY() + check.getY()) / 2.0, (loc.getZ() + check.getZ()) / 2.0);
                this.createExplosion(center);
                return;
            }
        }
    }

    private void createExplosion(Location center) {
        ParticleEffect.EXPLOSION_HUGE.display(center, 3, 4.0, 4.0, 4.0, 0.012);
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)center, (double)4.0)) {
            if (!(e instanceof LivingEntity)) continue;
            Vector direction = GeneralMethods.getDirection((Location)center, (Location)e.getLocation().clone().add(0.0, 0.75, 0.0));
            ParticleEffect.SWEEP_ATTACK.display(e.getLocation(), 1);
            e.setVelocity(direction.clone().multiply(3.5));
            DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
        }
    }

    public void displayParticles(Location loc) {
        EnergyColor use = this.color;
        if (this.color == EnergyColor.RAINBOW) {
            int r = new Random().nextInt(EnergyColor.values().length - 1);
            use = EnergyColor.values()[r];
        }
        GeneralMethods.displayColoredParticle((String)use.getHex(), (Location)loc, (int)4, (double)0.3, (double)0.3, (double)0.3);
    }

    public boolean damageEntities(Location loc) {
        Location next;
        boolean damaged = false;
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)loc, (double)1.5)) {
            if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
            LivingEntity le = (LivingEntity)e;
            if (this.effects) {
                if (this.color == EnergyColor.BLUE) {
                    DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                    damaged = true;
                    continue;
                }
                if (this.color == EnergyColor.GREEN) {
                    double health = le.getHealth() == le.getMaxHealth() ? le.getMaxHealth() : le.getHealth() + this.damage;
                    le.setHealth(health);
                    continue;
                }
                if (this.color == EnergyColor.ORANGE) {
                    DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                    le.setFireTicks(90);
                    damaged = true;
                    continue;
                }
                if (this.color == EnergyColor.BLACK) {
                    DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                    if (!this.player.hasPotionEffect(PotionEffectType.HEAL)) {
                        this.player.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 40, Math.round((float)this.damage) - 1), true);
                    }
                    damaged = true;
                    continue;
                }
                if (this.color == EnergyColor.RED) {
                    DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                    le.setNoDamageTicks(0);
                    damaged = true;
                    continue;
                }
                if (this.color == EnergyColor.PURPLE) {
                    if (!le.hasPotionEffect(PotionEffectType.SLOW)) {
                        le.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 30, 1), true);
                    }
                    if (!le.hasPotionEffect(PotionEffectType.CONFUSION)) {
                        le.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 30, 1), true);
                    }
                    if (le.hasPotionEffect(PotionEffectType.GLOWING)) continue;
                    le.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 80, 1), true);
                    continue;
                }
                if (this.color == EnergyColor.YELLOW) {
                    if (le.hasPotionEffect(PotionEffectType.LEVITATION)) continue;
                    le.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 80, 9), true);
                    continue;
                }
                if (this.color == EnergyColor.WHITE) {
                    e.setVelocity(GeneralMethods.getDirection((Location)e.getLocation(), (Location)loc).multiply(0.5));
                    damaged = true;
                    continue;
                }
                if (this.color == EnergyColor.INDIGO) {
                    if (!le.hasPotionEffect(PotionEffectType.BLINDNESS)) {
                        le.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 80, 6), true);
                    }
                    if (le.hasPotionEffect(PotionEffectType.WITHER)) continue;
                    le.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 80, 2), true);
                    continue;
                }
                if (this.color == EnergyColor.PINK) {
                    ParticleEffect.HEART.display(le.getEyeLocation(), 8, 0.4, 0.4, 0.4, 0.012);
                    continue;
                }
                if (this.color == EnergyColor.AQUA) {
                    le.setRemainingAir(le.getRemainingAir() - 1);
                    continue;
                }
                if (this.color == EnergyColor.GRAY) {
                    le.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 30, 2), true);
                    continue;
                }
                if (this.color != EnergyColor.RAINBOW) continue;
                DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
                le.setFireTicks(90);
                le.setNoDamageTicks(0);
                e.setVelocity(this.map.get(loc).clone().multiply(3));
                if (!le.hasPotionEffect(PotionEffectType.SLOW)) {
                    le.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 30, 1), true);
                }
                if (!le.hasPotionEffect(PotionEffectType.CONFUSION)) {
                    le.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 30, 1), true);
                }
                if (!le.hasPotionEffect(PotionEffectType.GLOWING)) {
                    le.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 80, 1), true);
                }
                if (!le.hasPotionEffect(PotionEffectType.LEVITATION)) {
                    le.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 80, 9), true);
                }
                if (!this.player.hasPotionEffect(PotionEffectType.HEAL)) {
                    this.player.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 40, Math.round((float)this.damage) - 1), true);
                }
                damaged = true;
                continue;
            }
            DamageHandler.damageEntity((Entity)e, (Player)this.player, (double)this.damage, (Ability)this);
            damaged = true;
        }
        if (this.effects && this.color == EnergyColor.BROWN && GeneralMethods.isSolid((Block)(next = loc.clone().add(this.map.get(loc))).getBlock())) {
            this.player.setVelocity(GeneralMethods.getDirection((Location)this.player.getLocation(), (Location)loc).multiply(0.2));
        }
        return damaged;
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getDescription() {
        return "A powerful avatar ability that allows them to focus their energy into a destructive beam";
    }

    public String getInstructions() {
        return "Sneak and enjoy";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Avatar.EnergyBeam.Enabled");
    }

    public static enum EnergyColor {
        WHITE("ffffff"),
        BLACK("000000"),
        RED("ff5252"),
        BLUE("0111ff"),
        GREEN("229965"),
        PURPLE("c606ff"),
        YELLOW("c6c600"),
        ORANGE("ffa500"),
        INDIGO("0a0082"),
        BROWN("d2691e"),
        PINK("e77aea"),
        AQUA("00FFFF"),
        GRAY("647687"),
        RAINBOW("abcdef");

        private String hex;

        private EnergyColor(String hex) {
            this.hex = hex;
        }

        public String getHex() {
            return this.hex;
        }
    }
}

