/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.air;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.AirAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.Random;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Zephyr
extends AirAbility
implements AddonAbility {
    @Attribute(value="Radius")
    private double radius;
    @Attribute(value="Cooldown")
    private long cooldown;
    private int angle = new Random().nextInt(360);

    public Zephyr(Player player) {
        super(player);
        this.radius = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.Zephyr.Radius");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Air.Zephyr.Cooldown");
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead() || !this.player.isSneaking() || this.player.getLocation().getBlock().isLiquid()) {
            this.remove();
            return;
        }
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.player.getLocation(), (double)this.radius)) {
            if (!(e instanceof LivingEntity) || !(((LivingEntity)e).getEyeLocation().getY() >= this.player.getLocation().getY())) continue;
            ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 5, 2), true);
            ParticleEffect.CLOUD.display(e.getLocation(), 2, 0.3, 0.15, 0.3);
        }
        Location anim = this.player.getLocation().clone();
        for (int i = 0; i < 6; ++i) {
            Vector ortho = GeneralMethods.getOrthogonalVector((Vector)new Vector(0, 1, 0), (double)(60 * i + this.angle), (double)(this.radius + 0.5));
            anim.add(ortho);
            Zephyr.playAirbendingParticles((Location)anim, (int)1, (double)0.0, (double)0.0, (double)0.0);
            anim.subtract(ortho);
        }
        this.angle += 4;
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Zephyr";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Air.Zephyr.Enabled");
    }

    public String getDescription() {
        return "Use many gental air currents to slow the fall of entities around you, including yourself!";
    }

    public String getInstructions() {
        return "Sneak";
    }
}

