/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.air;

import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.AirAbility;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.util.ClickType;
import java.util.ArrayList;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Tailwind
extends AirAbility
implements ComboAbility,
AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown;
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Speed")
    private int speed;

    public Tailwind(Player player) {
        super(player);
        if (Tailwind.hasAbility((Player)player, Tailwind.class)) {
            return;
        }
        if (this.bPlayer.isOnCooldown((Ability)this)) {
            return;
        }
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Combos.Air.Tailwind.Cooldown");
        this.duration = ProjectAddons.instance.getConfig().getLong("Combos.Air.Tailwind.Duration");
        this.speed = ProjectAddons.instance.getConfig().getInt("Combos.Air.Tailwind.Speed") - 1;
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.getLocation().getBlock().isLiquid() && this.player.getEyeLocation().getBlock().isLiquid()) {
            this.remove();
            return;
        }
        if (this.getStartTime() + this.duration < System.currentTimeMillis()) {
            this.remove();
            return;
        }
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 10, this.speed, true, false), true);
        Tailwind.playAirbendingParticles((Location)this.player.getEyeLocation(), (int)3, (double)0.3, (double)0.4, (double)0.3);
        Tailwind.playAirbendingParticles((Location)this.player.getLocation().clone().add(0.0, 0.6, 0.0), (int)4, (double)0.2, (double)0.5, (double)0.2);
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return true;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Tailwind";
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public Object createNewComboInstance(Player player) {
        return new Tailwind(player);
    }

    public ArrayList<ComboManager.AbilityInformation> getCombination() {
        ArrayList<ComboManager.AbilityInformation> combo = new ArrayList<ComboManager.AbilityInformation>();
        combo.add(new ComboManager.AbilityInformation("AirBlast", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("AirBlast", ClickType.SHIFT_UP));
        combo.add(new ComboManager.AbilityInformation("AirBlast", ClickType.SHIFT_DOWN));
        combo.add(new ComboManager.AbilityInformation("AirBlast", ClickType.SHIFT_UP));
        return combo;
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Combos.Air.Tailwind.Enabled");
    }

    public String getDescription() {
        return "Create a tailwind behind you to increase your speed immensely!";
    }

    public String getInstructions() {
        return "AirBlast (Double Tap Sneak)";
    }
}

