/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.air;

import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.util.SoundAbility;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class SonicWave
extends SoundAbility
implements AddonAbility {
    @Attribute(value="Width")
    private double width = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.SonicWave.Width");
    @Attribute(value="Duration")
    private int duration = ProjectAddons.instance.getConfig().getInt("Abilities.Air.SonicWave.Nausea.Duration");
    @Attribute(value="Nausea")
    private int amp = ProjectAddons.instance.getConfig().getInt("Abilities.Air.SonicWave.Nausea.Power") + 1;
    @Attribute(value="Cooldown")
    private long cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Air.SonicWave.Cooldown");
    @Attribute(value="Range")
    private double maxRange = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.SonicWave.Range");
    private Map<Vector, Location> parts = new HashMap<Vector, Location>();
    private double range = 0.0;

    public SonicWave(Player player) {
        super(player);
        this.launch();
        this.start();
    }

    public void progress() {
        for (int j = 0; j < 10; ++j) {
            if (!this.player.isOnline() || this.player.isDead()) {
                this.remove();
                return;
            }
            Iterator<Vector> iter = this.parts.keySet().iterator();
            while (iter.hasNext()) {
                Vector v = iter.next();
                Location loc = this.parts.get(v);
                loc.add(v);
                if (!loc.getBlock().isPassable()) {
                    iter.remove();
                    continue;
                }
                for (Player p : this.player.getWorld().getPlayers()) {
                    BendingPlayer bp = BendingPlayer.getBendingPlayer((Player)p);
                    if (bp == null || !bp.hasElement(ProjectAddons.instance.getSoundElement())) continue;
                    p.spawnParticle(Particle.SPELL_MOB_AMBIENT, loc, 1, 0.0, 0.0, 0.0);
                    p.playNote(loc, Instrument.FLUTE, Note.sharp((int)2, (Note.Tone)Note.Tone.F));
                }
                for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)loc, (double)0.8)) {
                    if (!(e instanceof LivingEntity) || e.getEntityId() == this.player.getEntityId()) continue;
                    ((LivingEntity)e).addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, this.duration, this.amp), true);
                }
            }
            if (this.parts.isEmpty()) {
                this.remove();
                return;
            }
            this.range += 0.2;
            if (!(this.range > this.maxRange)) continue;
            this.remove();
            return;
        }
    }

    private void launch() {
        Location origin = GeneralMethods.getMainHandLocation((Player)this.player);
        for (double i = -this.width; i <= this.width; i += 2.0) {
            double angle = Math.toRadians(i);
            Vector direction = this.player.getEyeLocation().getDirection().clone();
            double x = direction.getX();
            double z = direction.getZ();
            double vx = x * Math.cos(angle) - z * Math.sin(angle);
            double vz = x * Math.sin(angle) + z * Math.cos(angle);
            direction.setX(vx);
            direction.setZ(vz);
            this.parts.put(direction.normalize().multiply(0.2), origin.clone());
        }
    }

    public void remove() {
        super.remove();
        this.bPlayer.addCooldown((Ability)this);
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "SonicWave";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Create a blastwave of ultrasonic waves to cause nausea to any entities it hits! Soundbenders are able to see the sonic wave!";
    }

    public String getInstructions() {
        return "left click";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Air.SonicWave.Enabled");
    }
}

