/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.air;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.ability.AirAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import com.projectkorra.projectkorra.object.HorizontalVelocityTracker;
import com.projectkorra.projectkorra.util.DamageHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MainHand;
import org.bukkit.util.Vector;

public class GaleGust
extends AirAbility
implements AddonAbility {
    @Attribute(value="Cooldown")
    private long cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Air.GaleGust.Cooldown");
    @Attribute(value="Knockback")
    private double knockback = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.GaleGust.Knockback");
    @Attribute(value="Radius")
    private double radius = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.GaleGust.Radius");
    @Attribute(value="Damage")
    private double damage = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.GaleGust.Damage");
    @Attribute(value="Range")
    private double range = ProjectAddons.instance.getConfig().getDouble("Abilities.Air.GaleGust.Range");
    private Location current;
    private Vector direction;
    private Set<Point> points;

    public GaleGust(Player player) {
        super(player);
        this.current = player.getMainHand() == MainHand.LEFT ? GeneralMethods.getLeftSide((Location)player.getLocation().clone().add(0.0, 1.2, 0.0), (double)0.55) : GeneralMethods.getRightSide((Location)player.getLocation().clone().add(0.0, 1.2, 0.0), (double)0.55);
        this.direction = player.getEyeLocation().getDirection().clone().normalize();
        this.points = new HashSet<Point>();
        this.bPlayer.addCooldown((Ability)this);
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.player.getLocation().distance(this.current) > this.range) {
            this.remove();
            return;
        }
        if (this.player.isSneaking()) {
            this.direction.add(this.player.getEyeLocation().getDirection()).normalize();
        }
        this.current = this.current.add(this.direction);
        if (!this.current.getBlock().isPassable()) {
            this.remove();
            return;
        }
        this.points.add(new Point(this.current.clone().setDirection(this.direction.clone())));
        for (Entity e : GeneralMethods.getEntitiesAroundPoint((Location)this.current, (double)this.radius)) {
            if (e.getEntityId() == this.player.getEntityId()) continue;
            if (e instanceof LivingEntity && this.damage > 0.0) {
                DamageHandler.damageEntity((Entity)e, (double)this.damage, (Ability)this);
            }
            e.setVelocity(this.direction.clone().multiply(this.knockback));
            new HorizontalVelocityTracker(e, this.player, 0L, (Ability)this);
            e.setFireTicks(0);
        }
        ArrayList<Point> remove = new ArrayList<Point>();
        for (Point point : this.points) {
            double radi = point.getRadius() + 0.12;
            if (radi > this.radius) {
                remove.add(point);
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                Vector ortho = GeneralMethods.getOrthogonalVector((Vector)point.getLocation().getDirection(), (double)((double)(120 * i) + point.getAngle()), (double)point.getRadius());
                GaleGust.playAirbendingParticles((Location)point.getLocation().clone().add(ortho), (int)1, (double)0.0, (double)0.0, (double)0.0);
            }
            point.setAngle(point.getAngle() + Math.random() * 60.0).setRadius(radi);
        }
        this.points.removeAll(remove);
        if (this.points.isEmpty()) {
            this.remove();
            return;
        }
    }

    public void remove() {
        super.remove();
    }

    public boolean isSneakAbility() {
        return true;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "GaleGust";
    }

    public Location getLocation() {
        return this.current;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Air.GaleGust.Enabled");
    }

    public String getDescription() {
        return "Create a very strong and sudden wind to blow away entities!";
    }

    public String getInstructions() {
        return "Left Click, Sneak to control";
    }

    public class Point {
        private Location point;
        private double radius;
        private double angle;

        private Point(Location point) {
            this.point = point;
            this.radius = 0.0;
            this.angle = 0.0;
        }

        public Location getLocation() {
            return this.point;
        }

        public double getRadius() {
            return this.radius;
        }

        public double getAngle() {
            return this.angle;
        }

        public Point setRadius(double radius) {
            this.radius = radius;
            return this;
        }

        public Point setAngle(double angle) {
            this.angle = angle;
            return this;
        }
    }
}

