/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons.ability.air;

import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.AddonAbility;
import com.projectkorra.projectkorra.attribute.Attribute;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.util.SoundAbility;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Note;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Deafen
extends SoundAbility
implements AddonAbility {
    @Attribute(value="Duration")
    private long duration;
    @Attribute(value="Cooldown")
    private long cooldown;
    private Player target;

    public Deafen(Player player) {
        super(player);
        Entity e = GeneralMethods.getTargetedEntity((Player)player, (double)10.0);
        if (e == null || !(e instanceof Player)) {
            return;
        }
        this.target = (Player)e;
        this.duration = ProjectAddons.instance.getConfig().getLong("Abilities.Air.Deafen.Duration");
        this.cooldown = ProjectAddons.instance.getConfig().getLong("Abilities.Air.Deafen.Cooldown");
        this.bPlayer.addCooldown((Ability)this);
        this.start();
    }

    public void progress() {
        if (!this.player.isOnline() || this.player.isDead()) {
            this.remove();
            return;
        }
        if (this.getStartTime() + this.duration < System.currentTimeMillis()) {
            this.remove();
            return;
        }
        if (!this.player.isSneaking()) {
            this.remove();
            return;
        }
        Entity e = GeneralMethods.getTargetedEntity((Player)this.player, (double)10.0);
        if (e == null || e.getEntityId() != this.target.getEntityId()) {
            this.remove();
            return;
        }
        this.target.playNote(this.target.getEyeLocation().add(new Vector(Math.random(), Math.random(), Math.random())), Instrument.BASS_GUITAR, Note.sharp((int)0, (Note.Tone)Note.Tone.F));
        for (Sound sound : Sound.values()) {
            if (sound.equals((Object)Sound.BLOCK_NOTE_BLOCK_BASS)) continue;
            this.target.stopSound(sound);
        }
    }

    public boolean isSneakAbility() {
        return false;
    }

    public boolean isHarmlessAbility() {
        return false;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getName() {
        return "Deafen";
    }

    public Location getLocation() {
        return null;
    }

    public void load() {
    }

    public void stop() {
    }

    public String getAuthor() {
        return "Simplicitee";
    }

    public String getVersion() {
        return ProjectAddons.instance.version();
    }

    public String getDescription() {
        return "Temporarily cause another player to go deaf by cancelling the sound waves around them!";
    }

    public String getInstructions() {
        return "Sneak while looking at a player";
    }

    public boolean isEnabled() {
        return ProjectAddons.instance.getConfig().getBoolean("Abilities.Air.Deafen.Enabled");
    }
}

