/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons;

import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.ProjectKorra;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.util.Collision;
import com.projectkorra.projectkorra.airbending.AirShield;
import com.projectkorra.projectkorra.configuration.Config;
import com.projectkorra.projectkorra.firebending.FireShield;
import java.io.File;
import java.util.Arrays;
import me.simplicitee.project.addons.BoardManager;
import me.simplicitee.project.addons.CustomMethods;
import me.simplicitee.project.addons.MainListener;
import me.simplicitee.project.addons.ProjectCommand;
import me.simplicitee.project.addons.ability.air.GaleGust;
import me.simplicitee.project.addons.ability.earth.Crumble;
import me.simplicitee.project.addons.ability.fire.CombustBeam;
import me.simplicitee.project.addons.ability.fire.FireDisc;
import me.simplicitee.project.addons.ability.water.RazorLeaf;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProjectAddons
extends JavaPlugin {
    public static ProjectAddons instance;
    private Config config;
    private BoardManager boards;
    private CustomMethods methods;
    private MainListener listener;
    private Element soundElement;

    public void onEnable() {
        instance = this;
        this.config = new Config(new File("project_addons.yml"));
        this.setupConfig();
        this.soundElement = new Element.SubElement("Sound", Element.AIR, Element.ElementType.BENDING, (Plugin)this){

            public ChatColor getColor() {
                return Element.AIR.getSubColor();
            }
        };
        CoreAbility.registerPluginAbilities((JavaPlugin)this, (String)"me.simplicitee.project.addons.ability");
        this.setupCollisions();
        this.listener = new MainListener(this);
        this.boards = this.config.get().getBoolean("Properties.BendingBoard.Enabled") ? new BoardManager(this) : null;
        this.getCommand("projectaddons").setExecutor((CommandExecutor)new ProjectCommand());
        this.methods = new CustomMethods(this);
    }

    public void onDisable() {
        if (this.boards != null) {
            this.boards.disable();
        }
        this.listener.revertSwappedBinds();
        if (CoreAbility.getAbility(Crumble.class) != null) {
            for (Crumble c : CoreAbility.getAbilities(Crumble.class)) {
                c.revert();
            }
        }
    }

    public String prefix() {
        return ChatColor.GRAY + "[" + ChatColor.GREEN + "ProjectAddons" + ChatColor.GRAY + "]";
    }

    public String version() {
        return this.prefix() + " v." + this.getDescription().getVersion();
    }

    public Element getSoundElement() {
        return this.soundElement;
    }

    public FileConfiguration getConfig() {
        return this.config.get();
    }

    public Config config() {
        return this.config;
    }

    public boolean isBoardEnabled() {
        return this.boards != null;
    }

    public BoardManager getBoardManager() {
        return this.boards;
    }

    public CustomMethods getMethods() {
        return this.methods;
    }

    private void setupConfig() {
        FileConfiguration c = this.config.get();
        c.addDefault("Properties.BendingBoard.Enabled", (Object)true);
        c.addDefault("Properties.BendingBoard.Title", (Object)"Binds");
        c.addDefault("Properties.BendingBoard.EmptySlot", (Object)"&o~ Slot %d ~");
        c.addDefault("Properties.BendingBoard.IndicatorMode", (Object)"bold");
        c.addDefault("Properties.MetallicBlocks", Arrays.asList("GOLD_BLOCK", "IRON_BLOCK"));
        c.addDefault("Abilities.Avatar.EnergyBeam.Enabled", (Object)true);
        c.addDefault("Abilities.Avatar.EnergyBeam.Cooldown", (Object)12000);
        c.addDefault("Abilities.Avatar.EnergyBeam.Duration", (Object)10000);
        c.addDefault("Abilities.Avatar.EnergyBeam.Damage", (Object)3);
        c.addDefault("Abilities.Avatar.EnergyBeam.Range", (Object)40);
        c.addDefault("Abilities.Avatar.EnergyBeam.EasterEgg", (Object)true);
        c.addDefault("Abilities.Air.Deafen.Enabled", (Object)true);
        c.addDefault("Abilities.Air.Deafen.Cooldown", (Object)10000);
        c.addDefault("Abilities.Air.Deafen.Duration", (Object)6000);
        c.addDefault("Abilities.Air.GaleGust.Enabled", (Object)true);
        c.addDefault("Abilities.Air.GaleGust.Cooldown", (Object)9000);
        c.addDefault("Abilities.Air.GaleGust.Damage", (Object)4);
        c.addDefault("Abilities.Air.GaleGust.Radius", (Object)1);
        c.addDefault("Abilities.Air.GaleGust.Range", (Object)18);
        c.addDefault("Abilities.Air.GaleGust.Knockback", (Object)0.67);
        c.addDefault("Abilities.Air.SonicWave.Enabled", (Object)true);
        c.addDefault("Abilities.Air.SonicWave.Cooldown", (Object)4000);
        c.addDefault("Abilities.Air.SonicWave.Range", (Object)25);
        c.addDefault("Abilities.Air.SonicWave.Width", (Object)10);
        c.addDefault("Abilities.Air.SonicWave.Nausea.Duration", (Object)120);
        c.addDefault("Abilities.Air.SonicWave.Nausea.Power", (Object)2);
        c.addDefault("Abilities.Air.VocalMimicry.Enabled", (Object)true);
        c.addDefault("Abilities.Air.VocalMimicry.Volume", (Object)0.7);
        c.addDefault("Abilities.Air.VocalMimicry.Pitch", (Object)1);
        c.addDefault("Abilities.Air.VocalMimicry.SoundBlacklist", Arrays.asList("SOUND_NAME_HERE"));
        c.addDefault("Abilities.Air.Zephyr.Enabled", (Object)true);
        c.addDefault("Abilities.Air.Zephyr.Cooldown", (Object)1000);
        c.addDefault("Abilities.Air.Zephyr.Radius", (Object)4);
        c.addDefault("Combos.Air.Tailwind.Enabled", (Object)true);
        c.addDefault("Combos.Air.Tailwind.Cooldown", (Object)7000);
        c.addDefault("Combos.Air.Tailwind.Duration", (Object)22000);
        c.addDefault("Combos.Air.Tailwind.Speed", (Object)9);
        c.addDefault("Passives.Earth.LandLaunch.Enabled", (Object)true);
        c.addDefault("Passives.Earth.LandLaunch.Power", (Object)3);
        c.addDefault("Abilities.Earth.Accretion.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.Accretion.Cooldown", (Object)10000);
        c.addDefault("Abilities.Earth.Accretion.Damage", (Object)1);
        c.addDefault("Abilities.Earth.Accretion.Blocks", (Object)8);
        c.addDefault("Abilities.Earth.Accretion.SelectRange", (Object)6);
        c.addDefault("Abilities.Earth.Accretion.RevertTime", (Object)20000);
        c.addDefault("Abilities.Earth.Bulwark.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.Bulwark.Cooldown", (Object)6000);
        c.addDefault("Abilities.Earth.Crumble.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.Crumble.Cooldown", (Object)3000);
        c.addDefault("Abilities.Earth.Crumble.Radius", (Object)6);
        c.addDefault("Abilities.Earth.Crumble.SelectRange", (Object)9);
        c.addDefault("Abilities.Earth.Crumble.RevertTime", (Object)60);
        c.addDefault("Abilities.Earth.Dig.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.Dig.Cooldown", (Object)3000);
        c.addDefault("Abilities.Earth.Dig.Duration", (Object)-1);
        c.addDefault("Abilities.Earth.Dig.RevertTime", (Object)3500);
        c.addDefault("Abilities.Earth.Dig.Speed", (Object)0.51);
        c.addDefault("Abilities.Earth.EarthKick.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.EarthKick.Cooldown", (Object)4000);
        c.addDefault("Abilities.Earth.EarthKick.Damage", (Object)0.5);
        c.addDefault("Abilities.Earth.EarthKick.MaxBlocks", (Object)9);
        c.addDefault("Abilities.Earth.EarthKick.LavaMultiplier", (Object)1.5);
        c.addDefault("Abilities.Earth.LavaSurge.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.LavaSurge.Cooldown", (Object)4000);
        c.addDefault("Abilities.Earth.LavaSurge.Damage", (Object)0.5);
        c.addDefault("Abilities.Earth.LavaSurge.Speed", (Object)1.14);
        c.addDefault("Abilities.Earth.LavaSurge.SelectRange", (Object)5);
        c.addDefault("Abilities.Earth.LavaSurge.SourceRadius", (Object)3);
        c.addDefault("Abilities.Earth.LavaSurge.MaxBlocks", (Object)10);
        c.addDefault("Abilities.Earth.LavaSurge.Burn.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.LavaSurge.Burn.Duration", (Object)3000);
        c.addDefault("Abilities.Earth.MagmaSlap.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.MagmaSlap.Cooldown", (Object)4000);
        c.addDefault("Abilities.Earth.MagmaSlap.Offset", (Object)1.5);
        c.addDefault("Abilities.Earth.MagmaSlap.Damage", (Object)2);
        c.addDefault("Abilities.Earth.MagmaSlap.Length", (Object)13);
        c.addDefault("Abilities.Earth.MagmaSlap.Width", (Object)1);
        c.addDefault("Abilities.Earth.MagmaSlap.RevertTime", (Object)7000);
        c.addDefault("Abilities.Earth.QuickWeld.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.QuickWeld.Cooldown", (Object)1000);
        c.addDefault("Abilities.Earth.QuickWeld.RepairAmount", (Object)25);
        c.addDefault("Abilities.Earth.QuickWeld.RepairInterval", (Object)1250);
        c.addDefault("Abilities.Earth.Shrapnel.Enabled", (Object)true);
        c.addDefault("Abilities.Earth.Shrapnel.Shot.Cooldown", (Object)2000);
        c.addDefault("Abilities.Earth.Shrapnel.Shot.Damage", (Object)2);
        c.addDefault("Abilities.Earth.Shrapnel.Shot.Speed", (Object)2.3);
        c.addDefault("Abilities.Earth.Shrapnel.Blast.Cooldown", (Object)8000);
        c.addDefault("Abilities.Earth.Shrapnel.Blast.Shots", (Object)9);
        c.addDefault("Abilities.Earth.Shrapnel.Blast.Spread", (Object)24);
        c.addDefault("Abilities.Earth.Shrapnel.Blast.Speed", (Object)1.7);
        c.addDefault("Combos.Earth.RockSlide.Enabled", (Object)true);
        c.addDefault("Combos.Earth.RockSlide.Cooldown", (Object)7000);
        c.addDefault("Combos.Earth.RockSlide.Damage", (Object)1);
        c.addDefault("Combos.Earth.RockSlide.Knockback", (Object)0.9);
        c.addDefault("Combos.Earth.RockSlide.Knockup", (Object)0.4);
        c.addDefault("Combos.Earth.RockSlide.Speed", (Object)1.1);
        c.addDefault("Combos.Earth.RockSlide.RequiredRockCount", (Object)6);
        c.addDefault("Abilities.Fire.ArcSpark.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.ArcSpark.Speed", (Object)6);
        c.addDefault("Abilities.Fire.ArcSpark.Length", (Object)7);
        c.addDefault("Abilities.Fire.ArcSpark.Damage", (Object)1);
        c.addDefault("Abilities.Fire.ArcSpark.Cooldown", (Object)6500);
        c.addDefault("Abilities.Fire.ArcSpark.Duration", (Object)4000);
        c.addDefault("Abilities.Fire.ArcSpark.ChargeTime", (Object)500);
        c.addDefault("Abilities.Fire.CombustBeam.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.CombustBeam.Range", (Object)50);
        c.addDefault("Abilities.Fire.CombustBeam.Cooldown", (Object)3750);
        c.addDefault("Abilities.Fire.CombustBeam.Minimum.Power", (Object)0.5);
        c.addDefault("Abilities.Fire.CombustBeam.Minimum.Angle", (Object)1);
        c.addDefault("Abilities.Fire.CombustBeam.Minimum.ChargeTime", (Object)1000);
        c.addDefault("Abilities.Fire.CombustBeam.Maximum.Power", (Object)2.2);
        c.addDefault("Abilities.Fire.CombustBeam.Maximum.Angle", (Object)70);
        c.addDefault("Abilities.Fire.CombustBeam.Maximum.ChargeTime", (Object)5000);
        c.addDefault("Abilities.Fire.CombustBeam.InterruptedDamage", (Object)10);
        c.addDefault("Abilities.Fire.ChargeBolt.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.ChargeBolt.Damage", (Object)2);
        c.addDefault("Abilities.Fire.ChargeBolt.Cooldown", (Object)8000);
        c.addDefault("Abilities.Fire.ChargeBolt.Speed", (Object)6);
        c.addDefault("Abilities.Fire.ChargeBolt.ChargeTime", (Object)3000);
        c.addDefault("Abilities.Fire.ChargeBolt.BoltRange", (Object)26);
        c.addDefault("Abilities.Fire.ChargeBolt.BlastRadius", (Object)13);
        c.addDefault("Abilities.Fire.ChargeBolt.DischargeBoltCount", (Object)6);
        c.addDefault("Abilities.Fire.Electrify.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.Electrify.Cooldown", (Object)4000);
        c.addDefault("Abilities.Fire.Electrify.Duration", (Object)7000);
        c.addDefault("Abilities.Fire.Electrify.DamageInWater", (Object)2);
        c.addDefault("Abilities.Fire.Electrify.Slowness", (Object)2);
        c.addDefault("Abilities.Fire.Electrify.Weakness", (Object)1);
        c.addDefault("Abilities.Fire.Explode.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.Explode.Cooldown", (Object)4500);
        c.addDefault("Abilities.Fire.Explode.Damage", (Object)2);
        c.addDefault("Abilities.Fire.Explode.Radius", (Object)2.4);
        c.addDefault("Abilities.Fire.Explode.Knockback", (Object)1.94);
        c.addDefault("Abilities.Fire.Explode.Range", (Object)7.4);
        c.addDefault("Abilities.Fire.FireDisc.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.FireDisc.Damage", (Object)1.5);
        c.addDefault("Abilities.Fire.FireDisc.Range", (Object)32);
        c.addDefault("Abilities.Fire.FireDisc.Cooldown", (Object)1700);
        c.addDefault("Abilities.Fire.FireDisc.Controllable", (Object)true);
        c.addDefault("Abilities.Fire.FireDisc.RevertCutBlocks", (Object)true);
        c.addDefault("Abilities.Fire.FireDisc.DropCutBlocks", (Object)false);
        c.addDefault("Abilities.Fire.FireDisc.CuttableBlocks", Arrays.asList("ACACIA_LOG", "OAK_LOG", "JUNGLE_LOG", "BIRCH_LOG", "DARK_OAK_LOG", "SPRUCE_LOG"));
        c.addDefault("Abilities.Fire.Jets.Enabled", (Object)true);
        c.addDefault("Abilities.Fire.Jets.Cooldown", (Object)8000);
        c.addDefault("Abilities.Fire.Jets.Duration", (Object)20000);
        c.addDefault("Abilities.Fire.Jets.FlySpeed", (Object)0.65);
        c.addDefault("Abilities.Fire.Jets.HoverSpeed", (Object)0.065);
        c.addDefault("Abilities.Fire.Jets.SpeedThreshold", (Object)2.4);
        c.addDefault("Abilities.Fire.Jets.DamageThreshold", (Object)4);
        c.addDefault("Combos.Fire.FlameBreath.Enabled", (Object)true);
        c.addDefault("Combos.Fire.FlameBreath.Cooldown", (Object)8000);
        c.addDefault("Combos.Fire.FlameBreath.Damage", (Object)1.25);
        c.addDefault("Combos.Fire.FlameBreath.FireTick", (Object)30);
        c.addDefault("Combos.Fire.FlameBreath.Range", (Object)5);
        c.addDefault("Combos.Fire.FlameBreath.Duration", (Object)4000);
        c.addDefault("Combos.Fire.FlameBreath.Burn.Ground", (Object)true);
        c.addDefault("Combos.Fire.FlameBreath.Burn.Entities", (Object)true);
        c.addDefault("Combos.Fire.FlameBreath.Rainbow", (Object)true);
        c.addDefault("Combos.Fire.TurboJet.Enabled", (Object)true);
        c.addDefault("Combos.Fire.TurboJet.Cooldown", (Object)12000);
        c.addDefault("Combos.Fire.TurboJet.Speed", (Object)1.95);
        c.addDefault("Passives.Water.Hydrojet.Enabled", (Object)true);
        c.addDefault("Passives.Water.Hydrojet.Speed", (Object)8);
        c.addDefault("Abilities.Water.RazorLeaf.Enabled", (Object)true);
        c.addDefault("Abilities.Water.RazorLeaf.Cooldown", (Object)3000);
        c.addDefault("Abilities.Water.RazorLeaf.Damage", (Object)2);
        c.addDefault("Abilities.Water.RazorLeaf.Radius", (Object)0.7);
        c.addDefault("Abilities.Water.RazorLeaf.Range", (Object)24);
        c.addDefault("Abilities.Water.RazorLeaf.Particles", (Object)300);
        c.addDefault("Abilities.Water.PlantArmor.Enabled", (Object)true);
        c.addDefault("Abilities.Water.PlantArmor.Cooldown", (Object)10000);
        c.addDefault("Abilities.Water.PlantArmor.Duration", (Object)-1);
        c.addDefault("Abilities.Water.PlantArmor.Durability", (Object)2000);
        c.addDefault("Abilities.Water.PlantArmor.SelectRange", (Object)9);
        c.addDefault("Abilities.Water.PlantArmor.RequiredPlants", (Object)14);
        c.addDefault("Abilities.Water.PlantArmor.Boost.Swim", (Object)3);
        c.addDefault("Abilities.Water.PlantArmor.Boost.Speed", (Object)2);
        c.addDefault("Abilities.Water.PlantArmor.Boost.Jump", (Object)2);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Cost", (Object)50);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Cooldown", (Object)2000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Damage", (Object)2);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.VineWhip.Range", (Object)18);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.RazorLeaf.Cost", (Object)150);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafShield.Cost", (Object)100);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafShield.Cooldown", (Object)1500);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafShield.Radius", (Object)2);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Tangle.Cost", (Object)200);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Tangle.Cooldown", (Object)7000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Tangle.Radius", (Object)0.45);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Tangle.Duration", (Object)3000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Tangle.Range", (Object)18);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Leap.Cost", (Object)100);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Leap.Cooldown", (Object)2500);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Leap.Power", (Object)1.4);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Grapple.Cost", (Object)100);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Grapple.Cooldown", (Object)2000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Grapple.Range", (Object)25);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Grapple.Speed", (Object)1.24);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafDome.Cost", (Object)400);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafDome.Cooldown", (Object)5000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.LeafDome.Radius", (Object)3);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Regenerate.Cooldown", (Object)10000);
        c.addDefault("Abilities.Water.PlantArmor.SubAbilities.Regenerate.RegenAmount", (Object)150);
        c.addDefault("Combos.Water.LeafStorm.Enabled", (Object)true);
        c.addDefault("Combos.Water.LeafStorm.Cooldown", (Object)7000);
        c.addDefault("Combos.Water.LeafStorm.PlantArmorCost", (Object)800);
        c.addDefault("Combos.Water.LeafStorm.LeafCount", (Object)10);
        c.addDefault("Combos.Water.LeafStorm.LeafSpeed", (Object)14);
        c.addDefault("Combos.Water.LeafStorm.Damage", (Object)0.5);
        c.addDefault("Combos.Water.LeafStorm.Radius", (Object)6);
        c.addDefault("Combos.Water.MistShards.Enabled", (Object)true);
        c.addDefault("Combos.Water.MistShards.Cooldown", (Object)7000);
        c.addDefault("Combos.Water.MistShards.Damage", (Object)1);
        c.addDefault("Combos.Water.MistShards.Range", (Object)20);
        c.addDefault("Combos.Water.MistShards.IcicleCount", (Object)8);
        c.addDefault("Passives.Chi.Dodging.Enabled", (Object)true);
        c.addDefault("Passives.Chi.Dodging.Chance", (Object)18);
        c.addDefault("Passives.Chi.Camouflage.Enabled", (Object)true);
        c.addDefault("Abilities.Chi.Jab.Enabled", (Object)true);
        c.addDefault("Abilities.Chi.Jab.Cooldown", (Object)3000);
        c.addDefault("Abilities.Chi.Jab.MaxUses", (Object)4);
        c.addDefault("Abilities.Chi.NinjaStance.Enabled", (Object)true);
        c.addDefault("Abilities.Chi.NinjaStance.Cooldown", (Object)0);
        c.addDefault("Abilities.Chi.NinjaStance.Stealth.Duration", (Object)5000);
        c.addDefault("Abilities.Chi.NinjaStance.Stealth.ChargeTime", (Object)2000);
        c.addDefault("Abilities.Chi.NinjaStance.SpeedAmplifier", (Object)5);
        c.addDefault("Abilities.Chi.NinjaStance.JumpAmplifier", (Object)5);
        c.addDefault("Abilities.Chi.NinjaStance.DamageModifier", (Object)0.75);
        c.addDefault("Combos.Chi.ChiblockJab.Enabled", (Object)true);
        c.addDefault("Combos.Chi.ChiblockJab.Cooldown", (Object)5000);
        c.addDefault("Combos.Chi.ChiblockJab.Duration", (Object)2000);
        c.addDefault("Combos.Chi.FlyingKick.Enabled", (Object)true);
        c.addDefault("Combos.Chi.FlyingKick.Cooldown", (Object)4000);
        c.addDefault("Combos.Chi.FlyingKick.Damage", (Object)2.0);
        c.addDefault("Combos.Chi.FlyingKick.LaunchPower", (Object)1.85);
        c.addDefault("Combos.Chi.WeakeningJab.Enabled", (Object)true);
        c.addDefault("Combos.Chi.WeakeningJab.Cooldown", (Object)6000);
        c.addDefault("Combos.Chi.WeakeningJab.Duration", (Object)4000);
        c.addDefault("Combos.Chi.WeakeningJab.Modifier", (Object)1.5);
        this.config.save();
    }

    private void setupCollisions() {
        if (CoreAbility.getAbility(FireDisc.class) != null) {
            ProjectKorra.getCollisionInitializer().addSmallAbility(CoreAbility.getAbility(FireDisc.class));
        }
        if (CoreAbility.getAbility(RazorLeaf.class) != null) {
            ProjectKorra.getCollisionInitializer().addSmallAbility(CoreAbility.getAbility(RazorLeaf.class));
        }
        if (CoreAbility.getAbility(GaleGust.class) != null) {
            ProjectKorra.getCollisionInitializer().addSmallAbility(CoreAbility.getAbility(GaleGust.class));
        }
        if (CoreAbility.getAbility(CombustBeam.class) != null) {
            ProjectKorra.getCollisionInitializer().addLargeAbility(CoreAbility.getAbility(CombustBeam.class));
            ProjectKorra.getCollisionManager().addCollision(new Collision(CoreAbility.getAbility(FireShield.class), CoreAbility.getAbility(CombustBeam.class), false, true));
            ProjectKorra.getCollisionManager().addCollision(new Collision(CoreAbility.getAbility(AirShield.class), CoreAbility.getAbility(CombustBeam.class), false, true));
        }
    }
}

