/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons;

import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.Element;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.ProjectKorra;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.util.ComboManager;
import com.projectkorra.projectkorra.ability.util.MultiAbilityManager;
import com.projectkorra.projectkorra.event.BendingReloadEvent;
import com.projectkorra.projectkorra.event.PlayerBindChangeEvent;
import com.projectkorra.projectkorra.event.PlayerChangeElementEvent;
import com.projectkorra.projectkorra.event.PlayerCooldownChangeEvent;
import com.projectkorra.projectkorra.object.Preset;
import com.projectkorra.projectkorra.util.ActionBar;
import com.projectkorra.projectkorra.util.ClickType;
import java.util.HashMap;
import java.util.Map;
import me.simplicitee.project.addons.ProjectAddons;
import me.simplicitee.project.addons.ability.air.Deafen;
import me.simplicitee.project.addons.ability.air.GaleGust;
import me.simplicitee.project.addons.ability.air.SonicWave;
import me.simplicitee.project.addons.ability.air.VocalMimicry;
import me.simplicitee.project.addons.ability.air.Zephyr;
import me.simplicitee.project.addons.ability.avatar.EnergyBeam;
import me.simplicitee.project.addons.ability.chi.Dodging;
import me.simplicitee.project.addons.ability.chi.Jab;
import me.simplicitee.project.addons.ability.chi.NinjaStance;
import me.simplicitee.project.addons.ability.chi.WeakeningJab;
import me.simplicitee.project.addons.ability.earth.Accretion;
import me.simplicitee.project.addons.ability.earth.Bulwark;
import me.simplicitee.project.addons.ability.earth.Crumble;
import me.simplicitee.project.addons.ability.earth.Dig;
import me.simplicitee.project.addons.ability.earth.EarthKick;
import me.simplicitee.project.addons.ability.earth.Geoblast;
import me.simplicitee.project.addons.ability.earth.LavaSurge;
import me.simplicitee.project.addons.ability.earth.MagmaSlap;
import me.simplicitee.project.addons.ability.earth.QuickWeld;
import me.simplicitee.project.addons.ability.earth.ShrapnelBlast;
import me.simplicitee.project.addons.ability.earth.ShrapnelShot;
import me.simplicitee.project.addons.ability.fire.ArcSpark;
import me.simplicitee.project.addons.ability.fire.ChargeBolt;
import me.simplicitee.project.addons.ability.fire.CombustBeam;
import me.simplicitee.project.addons.ability.fire.Electrify;
import me.simplicitee.project.addons.ability.fire.Explode;
import me.simplicitee.project.addons.ability.fire.FireDisc;
import me.simplicitee.project.addons.ability.fire.Jets;
import me.simplicitee.project.addons.ability.water.MistShards;
import me.simplicitee.project.addons.ability.water.PlantArmor;
import me.simplicitee.project.addons.ability.water.RazorLeaf;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MainListener
implements Listener {
    private ProjectAddons plugin;
    private Map<Player, HashMap<Integer, String>> swapped;

    public MainListener(ProjectAddons plugin) {
        this.plugin = plugin;
        this.swapped = new HashMap<Player, HashMap<Integer, String>>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        Element e;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
        if (bPlayer == null) {
            return;
        }
        CoreAbility ability = bPlayer.getBoundAbility();
        if (ability == null) {
            if (MultiAbilityManager.hasMultiAbilityBound((Player)player) && MultiAbilityManager.getBoundMultiAbility((Player)player).equalsIgnoreCase("PlantArmor")) {
                ComboManager.addComboAbility((Player)player, (ClickType)ClickType.LEFT_CLICK);
                new PlantArmor(player, ClickType.LEFT_CLICK);
            }
            return;
        }
        Element element = e = ability.getElement() instanceof Element.SubElement ? ((Element.SubElement)ability.getElement()).getParentElement() : ability.getElement();
        if (e != Element.AVATAR && !bPlayer.hasElement(ability.getElement())) {
            return;
        }
        if (this.canBend(player, "FireDisc")) {
            new FireDisc(player);
        } else if (this.canBend(player, "MagmaSlap")) {
            new MagmaSlap(player);
        } else if (this.canBend(player, "Shrapnel")) {
            if (player.isSneaking()) {
                new ShrapnelBlast(player);
            } else {
                new ShrapnelShot(player);
            }
        } else if (this.canBend(player, "NinjaStance")) {
            new NinjaStance(player);
        } else if (this.canBend(player, "AcrobatStance") || this.canBend(player, "WarriorStance")) {
            if (CoreAbility.hasAbility((Player)player, NinjaStance.class)) {
                ((NinjaStance)CoreAbility.getAbility((Player)player, NinjaStance.class)).remove();
            }
        } else if (this.canBend(player, "LavaSurge")) {
            if (CoreAbility.hasAbility((Player)player, LavaSurge.class)) {
                ((LavaSurge)CoreAbility.getAbility((Player)player, LavaSurge.class)).shoot();
            }
        } else if (this.canBend(player, "GaleGust")) {
            new GaleGust(player);
        } else if (this.canBend(player, "Accretion")) {
            if (CoreAbility.hasAbility((Player)player, Accretion.class)) {
                ((Accretion)CoreAbility.getAbility((Player)player, Accretion.class)).shoot();
            }
        } else if (this.canBend(player, "Crumble")) {
            new Crumble(player, ClickType.LEFT_CLICK);
        } else if (this.canBend(player, "Geoblast", false)) {
            if (CoreAbility.hasAbility((Player)player, Geoblast.class)) {
                ((Geoblast)CoreAbility.getAbility((Player)player, Geoblast.class)).launch();
            }
        } else if (this.canBend(player, "ArcSpark")) {
            if (CoreAbility.hasAbility((Player)player, ArcSpark.class)) {
                ((ArcSpark)CoreAbility.getAbility((Player)player, ArcSpark.class)).shoot();
            }
        } else if (this.canBend(player, "CombustBeam")) {
            if (CoreAbility.hasAbility((Player)player, CombustBeam.class)) {
                ((CombustBeam)CoreAbility.getAbility((Player)player, CombustBeam.class)).explode();
            }
        } else if (this.canBend(player, "Jets")) {
            if (CoreAbility.hasAbility((Player)player, Jets.class)) {
                ((Jets)CoreAbility.getAbility((Player)player, Jets.class)).clickFunction();
            } else {
                new Jets(player);
            }
        } else if (this.canBend(player, "Bulwark")) {
            if (CoreAbility.hasAbility((Player)player, Bulwark.class)) {
                ((Bulwark)CoreAbility.getAbility((Player)player, Bulwark.class)).clickFunction();
            }
        } else if (this.canBend(player, "SonicWave")) {
            new SonicWave(player);
        } else if (this.canBend(player, "ChargeBolt")) {
            if (CoreAbility.hasAbility((Player)player, ChargeBolt.class)) {
                ((ChargeBolt)CoreAbility.getAbility((Player)player, ChargeBolt.class)).bolt();
            }
        } else if (this.canBend(player, "IceBlast", false) && CoreAbility.hasAbility((Player)player, MistShards.class)) {
            ((MistShards)CoreAbility.getAbility((Player)player, MistShards.class)).clickFunction();
        }
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent event) {
        Element e;
        if (event.isCancelled()) {
            return;
        }
        if (!event.isSneaking()) {
            return;
        }
        Player player = event.getPlayer();
        BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
        if (bPlayer == null) {
            return;
        }
        CoreAbility ability = bPlayer.getBoundAbility();
        if (ability == null) {
            if (MultiAbilityManager.hasMultiAbilityBound((Player)player) && MultiAbilityManager.getBoundMultiAbility((Player)player).equalsIgnoreCase("PlantArmor")) {
                ComboManager.addComboAbility((Player)player, (ClickType)ClickType.SHIFT_DOWN);
                new PlantArmor(player, ClickType.SHIFT_DOWN);
            }
            return;
        }
        Element element = e = ability.getElement() instanceof Element.SubElement ? ((Element.SubElement)ability.getElement()).getParentElement() : ability.getElement();
        if (e != Element.AVATAR && !bPlayer.hasElement(ability.getElement())) {
            return;
        }
        if (this.canBend(player, "EarthKick")) {
            new EarthKick(player);
        } else if (this.canBend(player, "NinjaStance")) {
            if (CoreAbility.hasAbility((Player)player, NinjaStance.class)) {
                ((NinjaStance)CoreAbility.getAbility((Player)player, NinjaStance.class)).beginStealth();
            }
        } else if (this.canBend(player, "EnergyBeam")) {
            new EnergyBeam(player);
        } else if (this.canBend(player, "Explode")) {
            new Explode(player);
        } else if (this.canBend(player, "LavaSurge")) {
            new LavaSurge(player);
        } else if (this.canBend(player, "QuickWeld")) {
            new QuickWeld(player, player.getInventory().getItemInMainHand());
        } else if (this.canBend(player, "RazorLeaf")) {
            new RazorLeaf(player, true);
        } else if (ability.getName().equals("PlantArmor")) {
            new PlantArmor(player, ClickType.SHIFT_DOWN);
        } else if (this.canBend(player, "Zephyr")) {
            new Zephyr(player);
        } else if (this.canBend(player, "Dig")) {
            new Dig(player);
        } else if (this.canBend(player, "Accretion")) {
            new Accretion(player);
        } else if (this.canBend(player, "Crumble")) {
            new Crumble(player, ClickType.SHIFT_UP);
        } else if (this.canBend(player, "Geoblast")) {
            new Geoblast(player);
        } else if (this.canBend(player, "ArcSpark")) {
            new ArcSpark(player);
        } else if (this.canBend(player, "CombustBeam")) {
            new CombustBeam(player);
        } else if (this.canBend(player, "Bulwark")) {
            new Bulwark(player);
        } else if (this.canBend(player, "VocalMimicry")) {
            new VocalMimicry(player);
        } else if (this.canBend(player, "Deafen")) {
            new Deafen(player);
        } else if (this.canBend(player, "ChargeBolt")) {
            new ChargeBolt(player);
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (event.getEntity().hasMetadata("shrapnel")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getItem().hasMetadata("shrapnel")) {
            event.getItem().removeMetadata("shrapnel", (Plugin)ProjectKorra.plugin);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Entity e = event.getEntity();
        if (e instanceof FallingBlock) {
            FallingBlock fb = (FallingBlock)e;
            if (EarthKick.isBlock(fb)) {
                event.setCancelled(true);
                EarthKick.removeBlock(fb);
            } else if (MagmaSlap.isBlock(fb)) {
                event.setCancelled(true);
                ((MagmaSlap)((Object)((MetadataValue)fb.getMetadata("magmaslap").get(0)).value())).turnToTempBlock(event.getBlock());
            } else if (fb.hasMetadata("earthring")) {
                event.setCancelled(true);
            } else if (fb.hasMetadata("lavasurge")) {
                event.setCancelled(true);
                ((LavaSurge)((Object)((MetadataValue)fb.getMetadata("lavasurge").get(0)).value())).removeBlock(fb);
            } else if (fb.hasMetadata("accretion")) {
                event.setCancelled(true);
                ((Accretion)((Object)((MetadataValue)fb.getMetadata("accretion").get(0)).value())).blockCollision(fb, event.getBlock());
            } else if (fb.hasMetadata("bulwark")) {
                event.setCancelled(true);
                fb.remove();
            } else if (fb.hasMetadata("rockslide")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
            if (bPlayer == null) {
                return;
            }
            if (CoreAbility.hasAbility((Player)player, NinjaStance.class)) {
                NinjaStance ninja = (NinjaStance)CoreAbility.getAbility((Player)player, NinjaStance.class);
                if (ninja.stealth && ninja.stealthReady && player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    ninja.stopStealth();
                }
            }
            if (MultiAbilityManager.hasMultiAbilityBound((Player)player, (String)"PlantArmor")) {
                if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                    event.setCancelled(true);
                    ((PlantArmor)CoreAbility.getAbility((Player)player, PlantArmor.class)).damage((int)event.getDamage() * 10);
                } else if (event.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                    event.setCancelled(true);
                    ((PlantArmor)CoreAbility.getAbility((Player)player, PlantArmor.class)).damage((int)event.getDamage() * 5);
                }
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL && CoreAbility.hasAbility((Player)player, Dig.class)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHitDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        Entity damagerE = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)event.getEntity();
            BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
            Dodging dodge = (Dodging)CoreAbility.getAbility((Player)player, Dodging.class);
            if (dodge != null && bPlayer.canBendPassive((CoreAbility)dodge) && bPlayer.isElementToggled(Element.CHI) && dodge.check()) {
                event.setCancelled(true);
                ActionBar.sendActionBar((String)(ChatColor.LIGHT_PURPLE + "!> " + Element.CHI.getColor() + "Dodged" + ChatColor.LIGHT_PURPLE + " <!"), (Player[])new Player[]{player});
                if (damagerE instanceof Player) {
                    ActionBar.sendActionBar((String)(ChatColor.LIGHT_PURPLE + "!> " + ChatColor.WHITE + player.getName() + Element.CHI.getColor() + " dodged" + ChatColor.LIGHT_PURPLE + " <!"), (Player[])new Player[]{(Player)damagerE});
                }
                return;
            }
        }
        if (WeakeningJab.isAffected(entity)) {
            event.setDamage(event.getDamage() * WeakeningJab.getModifier());
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).setNoDamageTicks(5);
            }
        }
        if (damagerE instanceof Player) {
            Player damager = (Player)damagerE;
            if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                return;
            }
            if (GeneralMethods.isWeapon((Material)damager.getInventory().getItemInMainHand().getType())) {
                return;
            }
            if (CoreAbility.hasAbility((Player)damager, NinjaStance.class)) {
                NinjaStance ninja = (NinjaStance)CoreAbility.getAbility((Player)damager, NinjaStance.class);
                if (ninja.stealth && ninja.stealthReady && damager.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    ninja.stopStealth();
                }
                event.setDamage(event.getDamage() * NinjaStance.getDamageModifier());
            }
            if (this.canBend(damager, "Jab")) {
                if (CoreAbility.hasAbility((Player)damager, Jab.class)) {
                    Jab jab = (Jab)CoreAbility.getAbility((Player)damager, Jab.class);
                    jab.activate(entity, Jab.JabHand.RIGHT);
                } else {
                    new Jab(damager, entity, Jab.JabHand.RIGHT);
                }
            }
        }
    }

    @EventHandler
    public void onRightClickBlock(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Player player = event.getPlayer();
        if (this.canBend(player, "Electrify")) {
            new Electrify(player, event.getClickedBlock(), true);
        }
    }

    @EventHandler
    public void onRightClickEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (this.canBend(player, "Jab")) {
            if (CoreAbility.hasAbility((Player)player, Jab.class)) {
                Jab jab = (Jab)CoreAbility.getAbility((Player)player, Jab.class);
                jab.activate(entity, Jab.JabHand.LEFT);
            } else {
                new Jab(player, entity, Jab.JabHand.LEFT);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String[] args = event.getMessage().split(" ");
        if (args[0].equalsIgnoreCase("@energycolor")) {
            if (!player.hasPermission("bending.ability.energybeam")) {
                player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " You do not have permission to change color");
            } else if (args.length != 2) {
                player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " Invalid format, try `@energycolor <color>`");
            } else {
                EnergyBeam.EnergyColor color = EnergyBeam.EnergyColor.valueOf(args[1].toUpperCase());
                if (color != null) {
                    EnergyBeam.colors.put(player.getUniqueId(), color);
                    player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.GREEN + " Successfully set EnergyBeam color to " + args[1].toLowerCase());
                } else {
                    player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " Unknown color! Try red, blue, yellow, green, purple, orange, indigo, brown, white, or black!");
                }
            }
            event.setCancelled(true);
        } else if (args[0].equalsIgnoreCase("@vocalsound")) {
            if (!player.hasPermission("bending.ability.VocalMimicry")) {
                player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " You do not have permission to change vocal noise");
            } else if (args.length != 2) {
                player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " Invalid format, try `@vocalsound <sound>`");
            } else {
                Sound sound = Sound.valueOf((String)args[1].toUpperCase());
                if (sound != null) {
                    if (this.plugin.getConfig().getStringList("Abilities.Air.VocalMimicry.SoundBlacklist").contains(sound.toString())) {
                        player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " Cannot use that sound!");
                    } else {
                        VocalMimicry.selectSound(player, sound);
                        player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.GREEN + " Successfully set vocal sound to " + args[1].toLowerCase());
                    }
                } else {
                    player.sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + ChatColor.RED + " Unknown sound!");
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onReload(BendingReloadEvent event) {
        ProjectAddons.instance.config().reload();
        event.getSender().sendMessage(String.valueOf(ProjectAddons.instance.prefix()) + " Config reloaded");
        new BukkitRunnable(){

            public void run() {
                CoreAbility.registerPluginAbilities((JavaPlugin)MainListener.this.plugin, (String)"me.simplicitee.project.addons.ability");
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        CoreAbility dig = CoreAbility.getAbility((Player)player, Dig.class);
        if (dig != null && dig.isStarted() && !event.isGliding()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAbilityChange(PlayerBindChangeEvent event) {
        if (event.isCancelled() || !this.plugin.isBoardEnabled()) {
            return;
        }
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                MainListener.this.plugin.getBoardManager().update(player);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCooldown(PlayerCooldownChangeEvent event) {
        if (event.isCancelled() || !this.plugin.isBoardEnabled()) {
            return;
        }
        final Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                MainListener.this.plugin.getBoardManager().update(player);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.plugin.isBoardEnabled()) {
            return;
        }
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                MainListener.this.plugin.getBoardManager().update(player);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isBoardEnabled()) {
            this.plugin.getBoardManager().remove(player);
        }
        if (this.swapped.containsKey(player)) {
            BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
            if (bPlayer != null) {
                bPlayer.setAbilities((Map)this.swapped.get(player));
            }
            this.swapped.remove(player);
        }
    }

    @EventHandler
    public void onElementChangeEvent(PlayerChangeElementEvent event) {
        if (!this.plugin.isBoardEnabled()) {
            return;
        }
        final Player player = event.getTarget();
        new BukkitRunnable(){

            public void run() {
                MainListener.this.plugin.getBoardManager().update(player);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onSlotChangeEvent(PlayerItemHeldEvent event) {
        if (event.isCancelled() || !this.plugin.isBoardEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        this.plugin.getBoardManager().update(player, event.getNewSlot());
    }

    @EventHandler
    public void onOffhandToggle(PlayerSwapHandItemsEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
        if (bPlayer == null) {
            return;
        }
        if (player.hasPermission("bending.offhandswap")) {
            if (MultiAbilityManager.hasMultiAbilityBound((Player)player)) {
                return;
            }
            if (this.swapped.containsKey(player)) {
                bPlayer.setAbilities((Map)this.swapped.get(player));
                this.swapped.remove(player);
                ActionBar.sendActionBar((String)(ChatColor.YELLOW + "Swapped to original binds"), (Player[])new Player[]{player});
            } else if (Preset.presetExists((Player)player, (String)"offhand_swap")) {
                this.swapped.put(player, new HashMap(bPlayer.getAbilities()));
                Preset.bindPreset((Player)player, (Preset)Preset.getPreset((Player)player, (String)"offhand_swap"));
                ActionBar.sendActionBar((String)(ChatColor.YELLOW + "Swapped to offhand preset"), (Player[])new Player[]{player});
            }
            if (this.plugin.isBoardEnabled()) {
                this.plugin.getBoardManager().update(player);
            }
        }
    }

    public void revertSwappedBinds() {
        for (Player player : this.swapped.keySet()) {
            BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
            if (bPlayer == null) continue;
            bPlayer.setAbilities((Map)this.swapped.get(player));
        }
        this.swapped.clear();
    }

    private boolean canBend(Player player, String ability) {
        return this.canBend(player, ability, true);
    }

    private boolean canBend(Player player, String ability, boolean canbend) {
        BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
        CoreAbility abil = CoreAbility.getAbility((String)ability);
        if (abil == null) {
            return false;
        }
        if (bPlayer.getBoundAbility() == null) {
            return false;
        }
        if (!bPlayer.getBoundAbilityName().equals(ability)) {
            return false;
        }
        if (canbend && !bPlayer.canBend(abil)) {
            return false;
        }
        if (GeneralMethods.isRegionProtectedFromBuild((Player)player, (String)ability, (Location)player.getLocation())) {
            return false;
        }
        return !GeneralMethods.isRegionProtectedFromBuild((Player)player, (String)ability, (Location)player.getEyeLocation());
    }
}

