/*
 * Decompiled with CFR 0.152.
 */
package me.simplicitee.project.addons;

import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.ability.Ability;
import com.projectkorra.projectkorra.ability.ComboAbility;
import com.projectkorra.projectkorra.ability.CoreAbility;
import com.projectkorra.projectkorra.ability.util.MultiAbilityManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.simplicitee.project.addons.ProjectAddons;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class BoardManager {
    private ProjectAddons plugin;
    private Set<UUID> disabled;
    private Map<UUID, Scoreboard> boards;
    private String empty;
    private String indicator;

    public BoardManager(ProjectAddons plugin) {
        this.plugin = plugin;
        this.disabled = new HashSet<UUID>();
        this.boards = new HashMap<UUID, Scoreboard>();
        this.empty = ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("Properties.BendingBoard.EmptySlot"));
        this.indicator = plugin.getConfig().getString("Properties.BendingBoard.IndicatorMode");
        if (!this.indicator.equalsIgnoreCase("bold") && !this.indicator.equalsIgnoreCase("arrow")) {
            this.indicator = "bold";
        }
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            for (Player player : plugin.getServer().getOnlinePlayers()) {
                this.update(player);
            }
        }, 60L);
    }

    public void disable() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            player.setScoreboard(this.plugin.getServer().getScoreboardManager().getMainScoreboard());
        }
        this.disabled.clear();
        this.boards.clear();
    }

    public void remove(Player player) {
        if (this.boards.containsKey(player.getUniqueId())) {
            player.setScoreboard(this.plugin.getServer().getScoreboardManager().getMainScoreboard());
            this.boards.remove(player.getUniqueId());
        }
    }

    public void update(Player player) {
        this.update(player, player.getInventory().getHeldItemSlot());
    }

    public void update(Player player, int newSlot) {
        int tracker;
        BendingPlayer bPlayer = BendingPlayer.getBendingPlayer((Player)player);
        if (this.disabled.contains(player.getUniqueId())) {
            this.remove(player);
            return;
        }
        if (!player.isOnline() || player.isDead()) {
            this.remove(player);
            return;
        }
        if (bPlayer == null) {
            this.remove(player);
            return;
        }
        if (bPlayer.getElements().isEmpty()) {
            this.remove(player);
            return;
        }
        if (bPlayer.isOnCooldown("MAM_setup")) {
            return;
        }
        if (!this.boards.containsKey(player.getUniqueId())) {
            this.boards.put(player.getUniqueId(), this.plugin.getServer().getScoreboardManager().getNewScoreboard());
        }
        Scoreboard scoreboard = this.boards.get(player.getUniqueId());
        HashMap<Integer, String> scores = new HashMap<Integer, String>();
        Objective bendingboard = scoreboard.getObjective("projectaddons");
        if (bendingboard == null) {
            bendingboard = scoreboard.registerNewObjective("projectaddons", "", "");
            bendingboard.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Properties.BendingBoard.Title")));
            bendingboard.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        for (String s : scoreboard.getEntries()) {
            scores.put(bendingboard.getScore(s).getScore(), s);
        }
        for (int i = 1; i < 10; ++i) {
            String color = "";
            String prefix = this.indicator.equalsIgnoreCase("arrow") ? ChatColor.BLACK + ">" : "";
            String format = "";
            String name = this.empty.replace("%d", i + "");
            if (newSlot == i - 1) {
                if (this.indicator.equalsIgnoreCase("arrow")) {
                    prefix = ChatColor.WHITE + ">";
                } else {
                    format = ChatColor.BOLD + "";
                }
            }
            if (bPlayer.getAbilities().containsKey(i)) {
                MultiAbilityManager.MultiAbilityInfo info;
                CoreAbility ability = CoreAbility.getAbility((String)((String)bPlayer.getAbilities().get(i)));
                if (ability != null) {
                    color = ability.getElement().getColor() + "";
                    name = ability.getName();
                    if (bPlayer.getStance() != null && ability.getName().equals(bPlayer.getStance().getName())) {
                        format = ChatColor.UNDERLINE + format;
                    }
                    if (bPlayer.isOnCooldown((Ability)ability)) {
                        format = ChatColor.STRIKETHROUGH + format;
                    }
                } else if (MultiAbilityManager.hasMultiAbilityBound((Player)player) && i - 1 < (info = MultiAbilityManager.getMultiAbility((String)MultiAbilityManager.getBoundMultiAbility((Player)player))).getAbilities().size()) {
                    MultiAbilityManager.MultiAbilityInfoSub sub = (MultiAbilityManager.MultiAbilityInfoSub)info.getAbilities().get(i - 1);
                    color = sub.getAbilityColor() + "";
                    name = sub.getName();
                    if (bPlayer.isOnCooldown(sub.getName())) {
                        format = ChatColor.STRIKETHROUGH + format;
                    }
                }
            }
            if (name.length() > 16) {
                name = name.substring(0, 15);
            }
            String score = "\u00a7" + i + "\u00a7r" + prefix + color + format + name;
            if (!scores.containsKey(-i)) {
                bendingboard.getScore(score).setScore(-i);
                continue;
            }
            if (((String)scores.get(-i)).equalsIgnoreCase(score)) continue;
            scoreboard.resetScores((String)scores.get(-i));
            bendingboard.getScore(score).setScore(-i);
        }
        boolean show = false;
        for (int i = tracker = -11; i >= -(scores.size() + 5); --i) {
            if (!scores.containsKey(i)) continue;
            scoreboard.resetScores((String)scores.get(i));
        }
        for (String cooldown : bPlayer.getCooldowns().keySet()) {
            CoreAbility ability = CoreAbility.getAbility((String)cooldown);
            if (ability == null || !(ability instanceof ComboAbility)) continue;
            String s = ability.getElement().getColor() + ChatColor.STRIKETHROUGH + ability.getName();
            bendingboard.getScore(s).setScore(tracker);
            show = true;
            --tracker;
        }
        if (show) {
            if (!scores.containsKey(-10)) {
                bendingboard.getScore("-- Combos --").setScore(-10);
            }
        } else {
            scoreboard.resetScores("-- Combos --");
        }
        player.setScoreboard(scoreboard);
    }

    public void setDisabled(Player player, boolean disabled) {
        if (disabled) {
            this.disabled.add(player.getUniqueId());
            Scoreboard scoreboard = player.getScoreboard();
            scoreboard.clearSlot(DisplaySlot.SIDEBAR);
            for (String entry : scoreboard.getEntries()) {
                scoreboard.resetScores(entry);
            }
        } else {
            this.disabled.remove(player.getUniqueId());
        }
    }

    public boolean toggleDisabled(Player player) {
        boolean disable = false;
        if (this.disabled.contains(player.getUniqueId())) {
            this.disabled.remove(player.getUniqueId());
        } else {
            this.disabled.add(player.getUniqueId());
            disable = true;
        }
        return disable;
    }
}

