/*
 * Decompiled with CFR 0.152.
 */
package it.areson.minecraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WarpWildCommand
implements CommandExecutor,
TabCompleter {
    private JavaPlugin plugin;
    private HashMap<Player, Integer> cooldowns;

    public WarpWildCommand(JavaPlugin plugin) {
        try {
            this.plugin = plugin;
            this.cooldowns = new HashMap();
            plugin.getCommand("wild").setExecutor((CommandExecutor)this);
            plugin.getCommand("wild").setTabCompleter((TabCompleter)this);
            plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
                for (Player player : plugin.getServer().getOnlinePlayers()) {
                    if (!this.cooldowns.containsKey(player)) continue;
                    if (this.cooldowns.get(player) <= 1) {
                        this.cooldowns.remove(player);
                        continue;
                    }
                    this.cooldowns.put(player, this.cooldowns.get(player) - 1);
                }
            }, 0L, 20L);
        }
        catch (NullPointerException e) {
            plugin.getLogger().severe("/wild command not declared in plugin.yml");
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length > 0 && strings[0].equals("reload") && commandSender.hasPermission("areson.warpwild.reload")) {
            this.plugin.reloadConfig();
            commandSender.sendMessage("Areson WildWarp reloaded config.");
            this.plugin.getLogger().info("Areson WildWarp reloaded config.");
        } else {
            try {
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    World world = player.getWorld();
                    if (!this.plugin.getConfig().isInt("block-range-min") || !this.plugin.getConfig().isInt("block-range-min")) {
                        this.plugin.getLogger().severe("The min and max range values must be integers. Visit the plugin's page to see the default config.");
                        return false;
                    }
                    if (this.cooldowns.containsKey(player)) {
                        String message = this.plugin.getConfig().getString("cooldown-message").replace("%SECS%", "" + this.cooldowns.get(player));
                        String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
                        player.sendMessage(colored);
                    } else {
                        int configMin = this.plugin.getConfig().getInt("block-range-min");
                        int configMax = this.plugin.getConfig().getInt("block-range-max");
                        int randomX = this.randomInt(configMin, configMax);
                        int randomZ = this.randomInt(configMin, configMax);
                        if (!this.plugin.getConfig().isInt("cooldown-seconds")) {
                            this.plugin.getLogger().severe("The cooldown value must be integer. Visit the plugin's page to see the default config.");
                            return false;
                        }
                        Optional<Location> highestBlockLocation = this.getHighestBlockLocation(world, randomX, randomZ);
                        if (highestBlockLocation.isPresent()) {
                            String message = this.plugin.getConfig().getString("wild-tp-message");
                            String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
                            player.teleport(highestBlockLocation.get().add(0.0, 1.0, 0.0));
                            player.sendMessage(colored);
                            int cooldown = this.plugin.getConfig().getInt("cooldown-seconds");
                            this.cooldowns.put(player, cooldown);
                        } else {
                            String message = this.plugin.getConfig().getString("wild-tp-error");
                            String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
                            player.sendMessage(colored);
                        }
                    }
                } else {
                    String message = this.plugin.getConfig().getString("not-a-player-message");
                    String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
                    commandSender.sendMessage(colored);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Please check if your config is valid. Visit the plugin's page to see the default config.");
                return false;
            }
        }
        return true;
    }

    public Optional<Location> getHighestBlockLocation(World world, int x, int z) {
        for (int i = 255; i > 0; --i) {
            if (new Location(world, (double)x, (double)i, (double)z).getBlock().getType() == Material.AIR) continue;
            return Optional.of(new Location(world, (double)x, (double)i, (double)z).add(0.0, 1.0, 0.0));
        }
        return Optional.empty();
    }

    public int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min)) + min;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (strings.length == 1 && commandSender.hasPermission("areson.warpwild.reload") && "reload".startsWith(strings[0])) {
            suggestions.add("reload");
        }
        return suggestions;
    }
}

