/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store.task;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.task.AbstractTask;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.store.StoreManager;

public class BalanceTopTask
extends AbstractTask<GamePoints> {
    public BalanceTopTask(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, Config.GENERAL_TOP_UPDATE_MIN * 60, true);
    }

    public void action() {
        ((GamePoints)this.plugin).info("Updating balance top...");
        long took = System.currentTimeMillis();
        StoreManager storeManager = ((GamePoints)this.plugin).getStoreManager();
        storeManager.getBalanceTop().clear();
        Map<String, Integer> map = ((GamePoints)this.plugin).getData().getUserBalance();
        map.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).forEach(entry -> storeManager.getBalanceTop().add(new AbstractMap.SimpleEntry<String, Integer>((String)entry.getKey(), (Integer)entry.getValue())));
        took = System.currentTimeMillis() - took;
        ((GamePoints)this.plugin).info("Balance top updated in " + took + " ms!");
    }
}

