/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store.object;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractLoadableItem;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.Colorizer;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointDiscount;
import su.nightexpress.gamepoints.api.store.IPointProduct;
import su.nightexpress.gamepoints.api.store.IPointStore;
import su.nightexpress.gamepoints.store.StoreView;
import su.nightexpress.gamepoints.store.object.PointDiscount;
import su.nightexpress.gamepoints.store.object.PointProduct;

public class PointStore
extends AbstractLoadableItem<GamePoints>
implements IPointStore {
    private String name;
    private boolean isPermissionRequired;
    private int pages;
    private final Set<IPointDiscount> discounts;
    private final Map<String, IPointProduct> productMap;
    private StoreView view;

    public PointStore(@NotNull GamePoints plugin, @NotNull JYML cfg) {
        super((NexPlugin)plugin, cfg);
        cfg.addMissing("Pages", (Object)1);
        cfg.saveChanges();
        this.setName(cfg.getString("Name", this.getId()));
        this.setPermissionRequired(cfg.getBoolean("Permission_Required"));
        this.setPages(cfg.getInt("Pages"));
        this.discounts = new HashSet<IPointDiscount>();
        for (String discountId : cfg.getSection("Discounts")) {
            String path = "Discounts." + discountId + ".";
            int dAmount = cfg.getInt(path + "Amount");
            HashMap<DayOfWeek, Set<LocalTime[]>> dTimes = new HashMap<DayOfWeek, Set<LocalTime[]>>();
            for (String dDayNames : cfg.getSection(path + "Times")) {
                HashSet<LocalTime[]> dDayTimes = new HashSet<LocalTime[]>();
                for (String dDayTimeRaw : cfg.getStringSet(path + "Times." + dDayNames)) {
                    String[] split = dDayTimeRaw.split("-");
                    if (split.length < 2) {
                        ((GamePoints)this.plugin).error("Discount time range is invalid for '" + dDayNames + "' days of '" + discountId + "' discount in '" + this.getId() + "' store!");
                        continue;
                    }
                    LocalTime timeStart = LocalTime.parse(split[0], DateTimeFormatter.ofPattern("HH:mm"));
                    LocalTime timeEnd = LocalTime.parse(split[1], DateTimeFormatter.ofPattern("HH:mm"));
                    dDayTimes.add(new LocalTime[]{timeStart, timeEnd});
                }
                for (String dDayName : dDayNames.split(",")) {
                    DayOfWeek dDay = (DayOfWeek)CollectionsUtil.getEnum((String)dDayName, DayOfWeek.class);
                    if (dDay == null) {
                        ((GamePoints)this.plugin).error("Invalid day '" + dDayName + "' in '" + discountId + "' discount in '" + this.getId() + "' store!");
                        continue;
                    }
                    dTimes.put(dDay, dDayTimes);
                }
            }
            PointDiscount discount = new PointDiscount(dAmount, dTimes);
            this.discounts.add(discount);
        }
        JYML cfgProducts = new JYML(cfg.getFile().getParentFile().getAbsolutePath(), "products.yml");
        this.productMap = new HashMap<String, IPointProduct>();
        for (String sId : cfgProducts.getSection("")) {
            String path = sId + ".";
            cfgProducts.addMissing(path + "Store.Page", (Object)1);
            cfgProducts.saveChanges();
            String pName = cfgProducts.getString(path + "Name", sId);
            List description = cfgProducts.getStringList(path + "Description");
            int pCost = cfgProducts.getInt(path + "Price");
            long pPurchaseCooldown = cfgProducts.getLong(path + "Purchase_Cooldown");
            int pPriority = cfgProducts.getInt(path + "Priority");
            Set pInherRewards = cfgProducts.getStringSet(path + "Inheritance.Rewards");
            Set pInherPrice = cfgProducts.getStringSet(path + "Inheritance.Price");
            ItemStack pPreview = cfgProducts.getItem(path + "Preview");
            if (pPreview.getType().isAir()) {
                plugin.error("Invalid product preview for '" + sId + "' in '" + this.getId() + "' store!");
                continue;
            }
            List pCommands = cfgProducts.getStringList(path + "Rewards.Commands");
            int pStorePage = cfgProducts.getInt(path + "Store.Page");
            int pStoreSlot = cfgProducts.getInt(path + "Store.Slot");
            PointProduct product = new PointProduct(this, sId, pName, description, pCost, pPurchaseCooldown, pPriority, pInherRewards, pInherPrice, pPreview, pCommands, pStorePage, pStoreSlot);
            this.productMap.put(product.getId(), product);
        }
        this.getProducts().stream().filter(IPointProduct::isOneTimedPurchase).forEach(productParent -> this.getProducts().stream().filter(IPointProduct::isOneTimedPurchase).forEach(productChild -> {
            if (productChild.getInheritedPrice().contains(productParent.getId()) || productChild.equals(productParent)) {
                productParent.getInheritedPrice().add(productChild.getId());
            }
        }));
        this.view = new StoreView(this, "View.");
    }

    public void clear() {
        if (this.view != null) {
            this.view.clear();
            this.view = null;
        }
    }

    public void onSave() {
    }

    @Override
    public boolean hasPermission(@NotNull Player player) {
        return !this.isPermissionRequired() || player.hasPermission("gamepoints.store." + this.getId());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = Colorizer.apply((String)name);
    }

    @Override
    public boolean isPermissionRequired() {
        return this.isPermissionRequired;
    }

    @Override
    public void setPermissionRequired(boolean permissionRequired) {
        this.isPermissionRequired = permissionRequired;
    }

    @Override
    public int getPages() {
        return this.pages;
    }

    @Override
    public void setPages(int pages) {
        this.pages = Math.max(1, pages);
    }

    @Override
    @NotNull
    public Set<IPointDiscount> getDiscounts() {
        return this.discounts;
    }

    @Override
    @Nullable
    public IPointDiscount getDiscount() {
        return this.getDiscounts().stream().filter(IPointDiscount::isAvailable).max(Comparator.comparingInt(IPointDiscount::getAmount)).orElse(null);
    }

    @Override
    @NotNull
    public Map<String, IPointProduct> getProductsMap() {
        return this.productMap;
    }

    @NotNull
    public StoreView getView() {
        return this.view;
    }
}

