/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store.object;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.gamepoints.api.store.IPointDiscount;

public class PointDiscount
implements IPointDiscount {
    private int amount;
    private final Map<DayOfWeek, Set<LocalTime[]>> times;

    public PointDiscount(int amount, @NotNull Map<DayOfWeek, Set<LocalTime[]>> times) {
        this.setAmount(amount);
        this.times = times;
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> str.replace("%discount_amount%", String.valueOf(this.getAmount()));
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    @NotNull
    public Map<DayOfWeek, Set<LocalTime[]>> getTimes() {
        return this.times;
    }
}

