/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store.menu;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.AbstractMenu;
import su.nexmedia.engine.api.menu.MenuItem;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointDiscount;
import su.nightexpress.gamepoints.api.store.IPointStore;

public class StoreMenuMain
extends AbstractMenu<GamePoints> {
    private final List<String> formatDiscount;

    public StoreMenuMain(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, JYML.loadOrExtract((NexPlugin)plugin, (String)"store.main.yml"), "");
        this.cfg.addMissing("Format.Discount", Arrays.asList("&7", "&e&l&n%discount_amount%% Discount!"));
        this.cfg.saveChanges();
        this.formatDiscount = Colorizer.apply((List)this.cfg.getStringList("Format.Discount"));
        for (String sId : this.cfg.getSection("Stores")) {
            IPointStore store = plugin.getStoreManager().getStore(sId);
            if (store == null) {
                plugin.error("Invalid store '" + sId + "' in main store!");
                continue;
            }
            MenuItem menuItem = this.cfg.getMenuItem("Stores." + sId);
            menuItem.setClickHandler((p, type, e) -> store.open(p));
            this.addItem(menuItem);
        }
        for (String id : this.cfg.getSection("Content")) {
            MenuItem guiItem = this.cfg.getMenuItem("Content." + id, MenuItemType.class);
            this.addItem(guiItem);
        }
    }

    public void onItemPrepare(@NotNull Player player, @NotNull MenuItem menuItem, @NotNull ItemStack item) {
        super.onItemPrepare(player, menuItem, item);
        IPointStore store = ((GamePoints)this.plugin).getStoreManager().getStore(menuItem.getId());
        if (store == null) {
            return;
        }
        IPointDiscount discount = store.getDiscount();
        ItemUtil.replaceLore((ItemStack)item, (String)"%discount%", discount == null ? Collections.emptyList() : this.formatDiscount);
        ItemUtil.replace((ItemStack)item, store.replacePlaceholders());
        if (discount != null) {
            ItemUtil.replace((ItemStack)item, (UnaryOperator)discount.replacePlaceholders());
        }
    }

    public boolean cancelClick(@NotNull InventoryClickEvent e, @NotNull AbstractMenu.SlotType slotType) {
        return true;
    }
}

