/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store.menu;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.AbstractMenu;
import su.nexmedia.engine.api.menu.MenuClick;
import su.nexmedia.engine.api.menu.MenuItem;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointProduct;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;

public class StoreMenuConfirmation
extends AbstractMenu<GamePoints> {
    private final int productSlot;
    private final Map<Player, IPointProduct> productMap;

    public StoreMenuConfirmation(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, JYML.loadOrExtract((NexPlugin)plugin, (String)"store.confirm.yml"), "");
        this.productSlot = this.cfg.getInt("Product_Slot");
        this.productMap = new WeakHashMap<Player, IPointProduct>();
        MenuClick click = (player, type, e) -> {
            Enum type2$temp = type;
            if (type2$temp instanceof MenuItemType) {
                MenuItemType type2 = (MenuItemType)type2$temp;
                IPointProduct product = this.productMap.remove(player);
                if (product == null) {
                    player.closeInventory();
                    return;
                }
                if (type2 == MenuItemType.CONFIRMATION_ACCEPT) {
                    PointUser user = (PointUser)plugin.getUserManager().getUserData(player);
                    user.purchaseProduct(player, product);
                    product.getStore().open(player);
                } else if (type2 == MenuItemType.CONFIRMATION_DECLINE) {
                    product.getStore().open(player);
                }
            }
        };
        for (String sId : this.cfg.getSection("Content")) {
            MenuItem menuItem = this.cfg.getMenuItem("Content." + sId, MenuItemType.class);
            if (menuItem.getType() != null) {
                menuItem.setClickHandler(click);
            }
            this.addItem(menuItem);
        }
    }

    public void open(@NotNull Player player, @NotNull IPointProduct product, @NotNull ItemStack item) {
        this.productMap.put(player, product);
        this.addItem(player, item, new int[]{this.productSlot});
        this.open(player, 1);
    }

    public void onItemPrepare(@NotNull Player player, @NotNull MenuItem menuItem, @NotNull ItemStack item) {
        super.onItemPrepare(player, menuItem, item);
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(player);
        IPointProduct product = this.productMap.get(player);
        if (product == null) {
            return;
        }
        ItemUtil.replace((ItemStack)item, str -> (String)product.replacePlaceholders().apply(str.replace("%product_price_inherited%", String.valueOf(user.getInheritedPriceForItem(product)))));
        ItemUtil.replace((ItemStack)item, Config.replacePlaceholders());
    }

    public void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
        super.onClose(player, e);
        this.productMap.remove(player);
    }

    public boolean cancelClick(@NotNull InventoryClickEvent e, @NotNull AbstractMenu.SlotType slotType) {
        return true;
    }
}

