/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AbstractMenu;
import su.nexmedia.engine.api.menu.MenuClick;
import su.nexmedia.engine.api.menu.MenuItem;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.utils.StringUtil;
import su.nexmedia.engine.utils.TimeUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointProduct;
import su.nightexpress.gamepoints.api.store.IPointStore;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;

public class StoreView
extends AbstractMenu<GamePoints> {
    private final IPointStore store;

    public StoreView(@NotNull IPointStore store, @NotNull String path) {
        super((NexPlugin)store.plugin(), store.getConfig(), path);
        this.store = store;
        MenuClick click = (player, type, e) -> {
            Enum type2$temp = type;
            if (type2$temp instanceof MenuItemType) {
                MenuItemType type2 = (MenuItemType)type2$temp;
                if (type2 == MenuItemType.RETURN) {
                    ((GamePoints)this.plugin).getStoreManager().getStoreMainMenu().open(player, 1);
                } else {
                    this.onItemClickDefault(player, type2);
                }
            }
        };
        for (String sId : this.cfg.getSection(path + "Content")) {
            MenuItem menuItem = this.cfg.getMenuItem(path + "Content." + sId, MenuItemType.class);
            if (menuItem.getType() != null) {
                menuItem.setClickHandler(click);
            }
            this.addItem(menuItem);
        }
    }

    public boolean onPrepare(@NotNull Player player, @NotNull Inventory inventory) {
        this.setPage(player, this.getPage(player), this.store.getPages());
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(player);
        for (IPointProduct product : this.store.getProducts()) {
            if (product.getStorePage() != this.getPage(player)) continue;
            ItemStack item = product.getPreview();
            this.replaceProduct(item, product, user);
            MenuItem menuItem = new MenuItem(item, new int[]{product.getStoreSlot()});
            menuItem.setClickHandler((player1, type, e) -> {
                ItemStack clicked = e.getCurrentItem();
                if (clicked == null) {
                    return;
                }
                if (!user.canPurchase(player, product, true)) {
                    return;
                }
                ((GamePoints)this.plugin).getStoreManager().getStoreConfirmation().open(player1, product, clicked);
            });
            this.addItem(player, menuItem);
        }
        return true;
    }

    private void replaceProduct(@NotNull ItemStack item, @NotNull IPointProduct product, @NotNull PointUser user) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        int priceInherited = user.getInheritedPriceForItem(product);
        String userProdPrice = String.valueOf(priceInherited);
        String userProdCooldown = TimeUtil.formatTimeLeft((long)user.getProductCooldown(product));
        List<String> formatProduct = new ArrayList<String>(Config.STORE_PRODUCT_DISPLAY_FORMAT);
        ArrayList<String> formatState = user.isProductOnCooldown(product) ? (product.isOneTimedPurchase() ? new ArrayList<String>(Config.STORE_PRODUCT_PURCHASE_FORMAT_ALREADY_HAVE) : new ArrayList<String>(Config.STORE_PRODUCT_PURCHASE_FORMAT_COOLDOWN)) : (priceInherited == 0 ? new ArrayList<String>(Config.STORE_PRODUCT_PURCHASE_FORMAT_ALREADY_HAVE) : new ArrayList<String>(Config.STORE_PRODUCT_PURCHASE_FORMAT_AVAILABLE));
        formatProduct = StringUtil.replace(formatProduct, (String)"%product_description%", (boolean)false, product.getDescription());
        formatProduct = StringUtil.replace(formatProduct, (String)"%purchase%", (boolean)false, formatState);
        formatProduct.replaceAll(str -> str.replace("%product_cooldown%", userProdCooldown).replace("%product_price_inherited%", userProdPrice));
        formatProduct.replaceAll(product.replacePlaceholders());
        formatProduct.replaceAll(Config.replacePlaceholders());
        formatProduct.replaceAll(user.replacePlaceholders());
        meta.setDisplayName(product.getName());
        meta.setLore(formatProduct);
        item.setItemMeta(meta);
    }

    public boolean cancelClick(@NotNull InventoryClickEvent e, @NotNull AbstractMenu.SlotType slotType) {
        return true;
    }
}

